// Spatial Index Library
//
// Copyright (C) 2003 Navel Ltd.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Contact information:
//  Mailing address:
//    Marios Hadjieleftheriou
//    University of California, Riverside
//    Department of Computer Science
//    Surge Building, Room 310
//    Riverside, CA 92521
//
//  Email:
//    marioh@cs.ucr.edu

#ifndef __spatialindex_timeregion_h
#define __spatialindex_timeregion_h

namespace SpatialIndex
{
	class TimeRegion : public Tools::Geometry::Region, public Tools::Geometry::ITimeShape
	{
	public:
		TimeRegion();
		TimeRegion(const double* pLow, const double* pHigh, const Tools::IInterval& ti, unsigned long dimension);
		TimeRegion(const double* pLow, const double* pHigh, double tStart, double tEnd, unsigned long dimension);
		TimeRegion(const Tools::Geometry::Point& low, const Tools::Geometry::Point& high, const Tools::IInterval& ti);
		TimeRegion(const Tools::Geometry::Point& low, const Tools::Geometry::Point& high, double tStart, double tEnd);
		TimeRegion(const Region& in, const Tools::IInterval& ti);
		TimeRegion(const Region& in, double tStart, double tEnd);
		TimeRegion(const TimePoint& low, const TimePoint& high);
		TimeRegion(const TimeRegion& in);
		virtual ~TimeRegion();

		virtual TimeRegion& operator=(const TimeRegion& r);
		virtual bool operator==(const TimeRegion&) const;

		virtual bool intersectsRegionInTime(const TimeRegion& in) const;
		virtual bool containsRegionInTime(const TimeRegion& in) const;
		virtual bool touchesRegionInTime(const TimeRegion& in) const;

		virtual bool containsPointInTime(const TimePoint& in) const;
		virtual bool touchesPointInTime(const TimePoint& in) const;

		virtual void combineRegionInTime(const TimeRegion& in);
		virtual void getCombinedRegionInTime(TimeRegion& out, const TimeRegion& in) const;

		//
		// IObject interface
		//
		virtual TimeRegion* clone() throw (Tools::NotSupportedException);

		//
		// ISerializable interface
		//
		virtual unsigned long getByteArraySize();
		virtual unsigned long loadFromByteArray(byte* const data);
		virtual void storeToByteArray(unsigned long& len, byte** data);

		//
		// ITimeShape interface
		//
		virtual bool intersectsShapeInTime(const Tools::Geometry::ITimeShape& in) const;
		virtual bool intersectsShapeInTime(const Tools::IInterval& ivI, const Tools::Geometry::ITimeShape& in) const;
		virtual bool containsShapeInTime(const Tools::Geometry::ITimeShape& in) const;
		virtual bool containsShapeInTime(const Tools::IInterval& ivI, const Tools::Geometry::ITimeShape& in) const;
		virtual bool touchesShapeInTime(const Tools::Geometry::ITimeShape& in) const;
		virtual bool touchesShapeInTime(const Tools::IInterval& ivI, const Tools::Geometry::ITimeShape& in) const;
		virtual double getAreaInTime() const;
		virtual double getAreaInTime(const Tools::IInterval& ivI) const;
		virtual double getIntersectingAreaInTime(const Tools::Geometry::ITimeShape& r) const;
		virtual double getIntersectingAreaInTime(const Tools::IInterval& ivI, const Tools::Geometry::ITimeShape& r) const;

		//
		// IInterval interface
		//
		virtual Tools::IInterval& operator=(const Tools::IInterval&);
		virtual double getLowerBound() const;
		virtual double getUpperBound() const;
		virtual void setBounds(double, double);
		virtual bool intersectsInterval(const Tools::IInterval& ti) const;
		virtual bool intersectsInterval(Tools::IntervalType t, const double start, const double end) const;
		virtual bool containsInterval(const Tools::IInterval& ti) const;
		virtual Tools::IntervalType getIntervalType() const;

		virtual void makeInfinite(unsigned long dimension);
		virtual void makeDimension(unsigned long dimension);

	public:
		double m_startTime;
		double m_endTime;

		friend std::ostream& operator<<(std::ostream& os, const TimeRegion& r);
	}; // TimeRegion

	std::ostream& operator<<(std::ostream& os, const TimeRegion& r);
}

#endif /* __spatialindex_timeregion_h */
