// Spatial Index Library
//
// Copyright (C) 2004 Navel Ltd.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Contact information:
//  Mailing address:
//    Marios Hadjieleftheriou
//    University of California, Riverside
//    Department of Computer Science
//    Surge Building, Room 310
//    Riverside, CA 92521
//
//  Email:
//    marioh@cs.ucr.edu

#ifndef __spatialindex_movingpoint_h
#define __spatialindex_movingpoint_h

namespace SpatialIndex
{
	class MovingPoint : public TimePoint, public IEvolvingShape
	{
	public:
		MovingPoint();
		MovingPoint(const double* pCoords, const double* pVCoords, const Tools::IInterval& ti, unsigned long dimension);
		MovingPoint(const double* pCoords, const double* pVCoords, double tStart, double tEnd, unsigned long dimension);
		MovingPoint(const Tools::Geometry::Point& p, const Tools::Geometry::Point& vp, const Tools::IInterval& ti);
		MovingPoint(const Tools::Geometry::Point& p, const Tools::Geometry::Point& vp, double tStart, double tEnd);
		MovingPoint(const MovingPoint& p);
		virtual ~MovingPoint();

		virtual MovingPoint& operator=(const MovingPoint& p);
		virtual bool operator==(const MovingPoint& p) const;

		virtual double getCoord(unsigned long index, double t) const throw (Tools::IndexOutOfBoundsException);
		virtual double getProjectedCoord(unsigned long index, double t) const throw (Tools::IndexOutOfBoundsException);
		virtual double getVCoord(unsigned long index) const throw (Tools::IndexOutOfBoundsException);
		virtual void getPointAtTime(double t, Tools::Geometry::Point& out) const;

		//
		// IObject interface
		//
		virtual MovingPoint* clone() throw (Tools::NotSupportedException);

		//
		// ISerializable interface
		//
		virtual unsigned long getByteArraySize();
		virtual unsigned long loadFromByteArray(byte* const data);
		virtual void storeToByteArray(unsigned long& len, byte** data);

		//
		// IEvolvingShape interface
		//
		virtual void getVMBR(Tools::Geometry::Region& out) const;
		virtual void getMBRAtTime(double t, Tools::Geometry::Region& out) const;

		virtual void makeInfinite(unsigned long dimension);
		virtual void makeDimension(unsigned long dimension);

	private:
		void initialize(
			const double* pCoords, const double* pVCoords,
			double tStart, double tEnd, unsigned long dimension);

	public:
		double* m_pVCoords;

		friend std::ostream& operator<<(std::ostream& os, const MovingPoint& pt);
	}; // MovingPoint

	std::ostream& operator<<(std::ostream& os, const MovingPoint& pt);
}

#endif /*__spatialindex_movingpoint_h*/
