/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class IntegerVector {
    private int[] integers;
    private final int capacityIncrement;
    private int size = 0;

    public IntegerVector(int initialCapacity) {
        this.integers = new int[initialCapacity];
        this.capacityIncrement = initialCapacity;
    }

    public IntegerVector(IntegerVector vec) {
        this.integers = new int[vec.integers.length];
        this.size = vec.size;
        this.capacityIncrement = vec.capacityIncrement;
        System.arraycopy(vec.integers, 0, this.integers, 0, this.size);
    }

    public IntegerVector(DataInputStream in) throws IOException {
        this.read(in);
        this.capacityIncrement = this.size / 2;
    }

    public void append(int integer) {
        this.ensureCapacity();
        this.integers[this.size++] = integer;
    }

    public void push(int integer) {
        this.ensureCapacity();
        this.integers[this.size++] = integer;
    }

    public int pop() {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException("Stack is empty.");
        }
        --this.size;
        return this.integers[this.size];
    }

    public void clear() {
        this.size = 0;
    }

    public void set(int integer, int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Illegal index for IntegerVector: " + index);
        }
        this.integers[index] = integer;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("You bad. You sent this IntegerVector a bad index. You sent " + index + " but it was supposed to be >= 0 and < " + this.size);
        }
        return this.integers[index];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void ensureCapacity() {
        if (this.size >= this.integers.length) {
            int newLength = this.integers.length * 2;
            int[] newData = new int[newLength];
            System.arraycopy(this.integers, 0, newData, 0, this.integers.length);
            this.integers = newData;
        }
    }

    public boolean contains(int value) {
        return this.getIndexOf(value) != -1;
    }

    public int getIndexOf(int value) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int current = this.integers[mid];
            if (current > value) {
                high = mid - 1;
                continue;
            }
            if (current < value) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int getIndexOfLargestValueLessThanOrEqualTo(int value) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int current = this.integers[mid];
            if (current > value) {
                high = mid - 1;
                continue;
            }
            if (current < value && mid < this.size - 1 && this.integers[mid + 1] <= value) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int getLargestValueLessThanOrEqualTo(int value) {
        int index = this.getIndexOfLargestValueLessThanOrEqualTo(value);
        return this.integers[index];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int i = 0;
        while (i < this.size) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(this.integers[i]);
            if (i + 1 < this.size) {
                builder.append(",");
            } else {
                builder.append("]");
            }
            ++i;
        }
        return builder.toString();
    }

    public void trimToSize() {
        int newLength = this.size;
        int[] newData = new int[newLength];
        System.arraycopy(this.integers, 0, newData, 0, newLength);
        this.integers = newData;
    }

    public int lastValue() {
        return this.integers[this.size - 1];
    }

    public void removeValueAt(int index) {
        if (index == this.size - 1) {
            this.pop();
        } else {
            System.arraycopy(this.integers, index + 1, this.integers, index, this.size - index - 1);
            --this.size;
        }
    }

    public void sortInAscendingOrder() {
        if (this.size > 0) {
            Arrays.sort(this.integers, 0, this.size);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.size());
        int i = 0;
        while (i < this.size) {
            out.writeInt(this.integers[i]);
            ++i;
        }
    }

    public void read(DataInputStream in) throws IOException {
        this.size = in.readInt();
        this.integers = new int[this.size];
        int i = 0;
        while (i < this.size) {
            this.integers[i] = in.readInt();
            ++i;
        }
    }
}

