/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.source;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.SourceFileMenuFactory;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.io.BreakpointDebugger;
import edu.cmu.hcii.whyline.ui.source.FileView;
import edu.cmu.hcii.whyline.ui.source.TokenView;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;

public final class LineView
extends View {
    private static final boolean DRAW_LINE_NUMBERS = true;
    private static final AlphaComposite FADE = AlphaComposite.getInstance(3, 0.5f);
    private static final AlphaComposite NORMAL = AlphaComposite.getInstance(2);
    private final FileView fileView;
    private final Line line;
    private int leftOfFirstNonWhitespaceToken = Integer.MIN_VALUE;

    public LineView(FileView fileView, Line line) {
        this.line = line;
        this.fileView = fileView;
        this.setLocalHeight(fileView.getLineHeight(), false);
        this.setLocalWidth(fileView.getWidthOfCharacter() * line.getNumberOfCharacters(), false);
        WhylineUI whylineUI = this.fileView.getWhylineUI();
        int charWidth = fileView.getWidthOfCharacter();
        int rightEdge = fileView.getWidthOfCharacter() * 5;
        for (Token token : line.getTokens()) {
            if (token.isWhitespace()) {
                String text = token.getText();
                int length = text.length();
                int numberOfCharacters = 0;
                int i = 0;
                while (i < length) {
                    numberOfCharacters += text.charAt(i) == '\t' ? "    ".length() : 1;
                    ++i;
                }
                int width = charWidth * numberOfCharacters;
                rightEdge += width;
                continue;
            }
            GlyphVector glyphs = token.isWhitespace() ? null : whylineUI.getTokenGlyphs(token);
            TokenView newTokenView = new TokenView(this, token, glyphs);
            if (token.isCode() && this.leftOfFirstNonWhitespaceToken < 0) {
                this.leftOfFirstNonWhitespaceToken = rightEdge;
            }
            newTokenView.setLocalLeft(rightEdge, false);
            newTokenView.setLocalTop(0.0, false);
            int width = charWidth * glyphs.getNumGlyphs();
            newTokenView.setLocalWidth(width, false);
            newTokenView.setLocalHeight((int)this.getLocalHeight(), false);
            this.addChild(newTokenView);
            rightEdge += width;
        }
        this.setLocalWidth(rightEdge, false);
        this.trim();
    }

    public TokenView getViewOf(Token token) {
        for (View child : this.getChildren()) {
            if (!(child instanceof TokenView) || ((TokenView)child).getToken() != token) continue;
            return (TokenView)child;
        }
        return null;
    }

    public double getAscent() {
        return this.fileView.getAscent();
    }

    public FileView getFileView() {
        return this.fileView;
    }

    public WhylineUI getWhylineUI() {
        return this.fileView.getWhylineUI();
    }

    public Instruction getFirstInstrumentedInstructionOnLine() {
        return this.fileView.getFirstInstrumentedInstructionOnLine(this);
    }

    public boolean handleMouseClick(int x, int y, int button) {
        WhylineUI whylineUI = this.getFileView().getWhylineUI();
        int breakpointLeft = this.getBreakpointLeft();
        if (whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT && x < breakpointLeft + this.getBreakpointDiameter()) {
            Line nearestLine = whylineUI.getBreakpointDebugger().getNearestBreakpointLine(this.line);
            if (nearestLine != null) {
                whylineUI.getBreakpointDebugger().toggleBreakpoint(nearestLine);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        if (this.getFileView().getHoveredLine() != this) {
            return false;
        }
        int menuX = (int)this.getGlobalLeft() + (int)((double)x - this.getLocalLeft());
        int menuY = (int)this.getGlobalTop() + (int)((double)y - this.getLocalTop());
        WhylinePopup popup = new WhylinePopup("");
        SourceFileMenuFactory.addQuestionsForLine(this.getWhylineUI(), popup, this.line);
        SourceFileMenuFactory.addQuestionsForMethod(this.getWhylineUI(), popup, this.line);
        return this.getContainer().showPopup(popup, menuX, menuY);
    }

    public void setEmphasized(boolean highlighted) {
        this.fileView.emphasizeLine(this, highlighted);
        this.repaint();
    }

    public int getLeftAfterWhitespace() {
        return this.leftOfFirstNonWhitespaceToken;
    }

    public Line getLine() {
        return this.line;
    }

    public void paintChildren(Graphics2D g) {
        AlphaComposite fade = this.getWhylineUI().getFilesView().getCurrentFade();
        if (fade != null) {
            boolean lineEmphasized = this.fileView.isLineEmphasized(this) || this.fileView.getHoveredLine() == this || this.fileView.doesHoveredMethodContain(this);
            boolean nothingEmphasized = this.fileView.isNothingEmphasized();
            boolean childSelected = false;
            boolean childEmphasized = false;
            TokenView selectedToken = this.fileView.getTokenUnderMouse();
            for (View v : this.getChildren()) {
                if (selectedToken == v) {
                    childSelected = true;
                }
                if (!this.fileView.isTokenEmphasized((TokenView)v)) continue;
                childEmphasized = true;
            }
            boolean normal = childSelected || childEmphasized || lineEmphasized || nothingEmphasized;
            g.setComposite(normal ? NORMAL : fade);
        }
        super.paintChildren(g);
        g.setComposite(NORMAL);
    }

    private int getBreakpointLeft() {
        return this.fileView.getWidthOfCharacter() * ((int)Math.log10(this.line.getLineNumber().getNumber()) + 3);
    }

    private int getBreakpointDiameter() {
        return (int)this.getLocalHeight() - 2;
    }

    public void paintBelowChildren(Graphics2D g) {
        WhylineUI whylineUI = this.getWhylineUI();
        if (whylineUI.getLinesUI().selectedTabContains(this.line)) {
            g.setColor(UI.getHighlightColor());
            if (whylineUI.getLinesUI().getSelectedLine() == this.line) {
                g.fillRoundRect(this.leftOfFirstNonWhitespaceToken, (int)this.getVisibleLocalTop(), (int)this.getLocalWidth(), (int)this.getLocalHeight(), UI.getRoundedness(), UI.getRoundedness());
            } else {
                g.drawRoundRect(this.leftOfFirstNonWhitespaceToken, (int)this.getVisibleLocalTop(), (int)this.getLocalWidth(), (int)this.getLocalHeight(), UI.getRoundedness(), UI.getRoundedness());
            }
        }
        if (whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT) {
            boolean isExecuting;
            BreakpointDebugger debugger = whylineUI.getBreakpointDebugger();
            boolean bl = isExecuting = debugger.isRunning() && debugger.getCurrentLine() == this.line;
            if (isExecuting) {
                g.setColor(UI.getRunningColor());
                g.fillRoundRect(0, (int)this.getVisibleLocalTop(), (int)this.getParent().getParent().getLocalWidth(), (int)this.getVisibleLocalHeight() + 1, UI.getRoundedness(), UI.getRoundedness());
            }
            int breakpointLeft = this.getBreakpointLeft();
            boolean isLineOver = this.getFileView().getLineOver() == this.line;
            boolean breakpointSet = debugger.hasBreakpoint(this.line);
            if (breakpointSet || isLineOver && debugger.getNearestBreakpointLine(this.line) == this.line) {
                int size = this.getBreakpointDiameter();
                g.setColor(UI.BREAKPOINT_COLOR);
                int y = (int)(this.getVisibleLocalTop() + 1.0);
                if (breakpointSet) {
                    g.fillOval(breakpointLeft, y, size, size);
                }
                g.setColor(Color.black);
                g.drawOval(breakpointLeft, y, size - 1, size - 1);
            }
        }
    }

    public void paintAboveChildren(Graphics2D g) {
        g.setColor(UI.getControlBorderColor());
        g.setFont(UI.getFixedFont());
        g.drawString(Integer.toString(this.line.getLineNumber().getNumber()), this.fileView.getWidthOfCharacter(), (int)(this.getVisibleLocalTop() + this.getAscent() + 1.0));
        if (this.fileView.getHoveredLine() == this) {
            int padding = 2;
            g.setStroke(UI.SELECTED_STROKE);
            g.setColor(UI.getHighlightColor());
            g.drawRoundRect((int)((double)this.leftOfFirstNonWhitespaceToken + this.getVisibleLocalLeft()) - padding, (int)this.getVisibleLocalTop() - padding, (int)(this.getVisibleLocalWidth() - (double)this.leftOfFirstNonWhitespaceToken) + padding * 2 - 1, (int)this.getVisibleLocalHeight() + padding * 2 - 1, 5, 5);
        }
    }
}

