/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineToolbar;
import edu.cmu.hcii.whyline.ui.qa.AnswerUI;
import edu.cmu.hcii.whyline.ui.qa.EventBlockView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.border.EmptyBorder;

public class SituationUI
extends WhylinePanel {
    private static final String PREVIOUS_BLOCK_TEXT = "<html><center>\u21e7<br><i>block";
    private static final String PREVIOUS_EVENT_TEXT = "<html><center>\u2190<br><i>event";
    private static final String NEXT_EVENT_TEXT = "<html><center>\u2192<br><i>event";
    private static final String PREVIOUS_IN_METHOD_TEXT = "<html><center>\u2190 in<br><i>method</i>";
    private static final String NEXT_IN_METHOD_TEXT = "<html><center>\u2192 in<br><i>method</i>";
    private static final String PREVIOUS_IN_THREAD_TEXT = "<html><center>\u2190 in<br><i>thread</i>";
    private static final String NEXT_IN_THREAD_TEXT = "<html><center>\u2192 in<br><i>thread</i>";
    private static final String HIDE_THREADS_TEXT = "<html><center>hide<br>threads";
    private static final String SHOW_THREADS_TEXT = "<html><center>show<br>threads";
    private static final String SINGLE_THREAD_TEXT = "<html><center>single<br>thread";
    private static final String COLLAPSE_TEXT = "<html><center>collapse/<br>expand";
    private final Answer answer;
    private final WhylineUI whylineUI;
    private final AnswerUI answerUI;
    private final VisualizationUI visualizationUI;
    private final WhylineLabel qa;
    private final WhylineButton previousEventLabel;
    private final WhylineButton nextEventLabel;
    private final WhylineButton previousBlockLabel;
    private final WhylineButton collapseLabel;
    private final WhylineButton previousInMethod;
    private final WhylineButton nextInMethod;
    private final WhylineButton previousInThread;
    private final WhylineButton nextInThread;
    private final WhylineButton showHideThreads;

    public SituationUI(AnswerUI answerUI, Answer answer) {
        this.answerUI = answerUI;
        this.whylineUI = answerUI.getWhylineUI();
        this.answer = answer;
        this.setLayout(new BorderLayout());
        this.visualizationUI = new VisualizationUI(this, answer);
        String tab = "&nbsp;&nbsp;";
        String qanda = "<html><font size=\"+1\"><b>Q</b></font>&nbsp;&nbsp;" + answer.getQuestion().getQuestionText() + "<br>" + "<font size=\"+1\"><b>A</b></font>" + "&nbsp;&nbsp;" + answer.getAnswerText();
        this.qa = new WhylineLabel("");
        this.qa.setFont(UI.getMediumFont());
        this.qa.setBorder(new EmptyBorder(-UI.getBorderPadding(), 0, 0, 0));
        this.qa.setText(qanda);
        if (answer.hasVisualizationContent()) {
            FontMetrics metrics = this.whylineUI.getGraphics().getFontMetrics(UI.getSmallFont());
            Dimension maxSize = new Dimension(metrics.charWidth('e') * 9, metrics.getHeight() * 2);
            this.previousEventLabel = new WhylineButton(PREVIOUS_EVENT_TEXT, this.whylineUI.getActions().goToPreviousEvent, maxSize, UI.getSmallFont(), "select event shown before selection in visualization");
            this.nextEventLabel = new WhylineButton(NEXT_EVENT_TEXT, this.whylineUI.getActions().goToNextEvent, maxSize, UI.getSmallFont(), "select event after selection in visualization");
            this.previousInMethod = new WhylineButton(PREVIOUS_IN_METHOD_TEXT, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SituationUI.this.visualizationUI.getVisualization().showPreviousOrNextEventInThreadOrMethod(true, true);
                }
            }, maxSize, UI.getSmallFont(), "select the previous event in this method");
            this.nextInMethod = new WhylineButton(NEXT_IN_METHOD_TEXT, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SituationUI.this.visualizationUI.getVisualization().showPreviousOrNextEventInThreadOrMethod(false, true);
                }
            }, maxSize, UI.getSmallFont(), "select the next event in this method");
            this.previousInThread = new WhylineButton(PREVIOUS_IN_THREAD_TEXT, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SituationUI.this.visualizationUI.getVisualization().showPreviousOrNextEventInThreadOrMethod(true, false);
                }
            }, maxSize, UI.getSmallFont(), "select the previous event in this thread");
            this.nextInThread = new WhylineButton(NEXT_IN_THREAD_TEXT, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SituationUI.this.visualizationUI.getVisualization().showPreviousOrNextEventInThreadOrMethod(false, false);
                }
            }, maxSize, UI.getSmallFont(), "select the next event in this thread");
            this.previousBlockLabel = new WhylineButton(PREVIOUS_BLOCK_TEXT, this.whylineUI.getActions().goToPreviousBlock, maxSize, UI.getSmallFont(), "select the previous call or conditional");
            this.collapseLabel = new WhylineButton(COLLAPSE_TEXT, this.whylineUI.getActions().collapseBlock, maxSize, UI.getSmallFont(), "collapse or expand the selected call or conditional");
            this.showHideThreads = new WhylineButton(SHOW_THREADS_TEXT, this.whylineUI.getActions().showHideThreads, maxSize, UI.getSmallFont(), "collapse or expand threads");
            WhylineToolbar toolbar = new WhylineToolbar(0);
            toolbar.add(this.qa);
            toolbar.addSeparator();
            toolbar.add(this.previousEventLabel);
            toolbar.add(this.nextEventLabel);
            toolbar.addSeparator();
            toolbar.add(this.previousInMethod);
            toolbar.add(this.nextInMethod);
            toolbar.addSeparator();
            toolbar.add(this.previousInThread);
            toolbar.add(this.nextInThread);
            toolbar.addSeparator();
            toolbar.add(this.previousBlockLabel);
            toolbar.addSeparator();
            toolbar.add(this.collapseLabel);
            toolbar.addSeparator();
            toolbar.add(this.showHideThreads);
            this.add((Component)toolbar, "North");
            this.add((Component)this.visualizationUI, "Center");
        } else {
            this.previousEventLabel = null;
            this.nextEventLabel = null;
            this.previousInMethod = null;
            this.nextInMethod = null;
            this.previousInThread = null;
            this.nextInThread = null;
            this.previousBlockLabel = null;
            this.collapseLabel = null;
            this.showHideThreads = null;
            this.add((Component)this.qa, "Center");
            this.qa.setFont(UI.getLargeFont().deriveFont(0));
        }
        this.updateHintsWith(null);
    }

    public AnswerUI getAnswerUI() {
        return this.answerUI;
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public Answer getAnswer() {
        return this.answer;
    }

    public VisualizationUI getVisualizationUI() {
        return this.visualizationUI;
    }

    public void updateHintsWith(View view) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.answer.hasVisualizationContent()) {
            return;
        }
        Color enabled = UI.getControlTextColor();
        Visualization viz = this.visualizationUI.getVisualization();
        this.previousEventLabel.setEnabled(this.visualizationUI.getEventBefore(view) != null);
        this.nextEventLabel.setEnabled(this.visualizationUI.getEventAfter(view) != null);
        this.previousInMethod.setEnabled(viz.getPreviousOrNextEventInThreadOrMethod(true, true) != null);
        this.nextInMethod.setEnabled(viz.getPreviousOrNextEventInThreadOrMethod(false, true) != null);
        this.previousInThread.setEnabled(viz.getPreviousOrNextEventInThreadOrMethod(true, false) != null);
        this.previousInThread.setEnabled(viz.getPreviousOrNextEventInThreadOrMethod(false, false) != null);
        this.previousBlockLabel.setEnabled(this.visualizationUI.getEnclosingBlock(view) != null);
        this.collapseLabel.setEnabled(view instanceof EventBlockView);
        if (this.visualizationUI.getVisualization().getNumberOfThreadRows() == 1) {
            this.showHideThreads.setEnabled(false);
            this.showHideThreads.setText(SINGLE_THREAD_TEXT);
            this.showHideThreads.setVisible(false);
        } else if (this.visualizationUI.getVisualization().areThreadsVisible()) {
            this.showHideThreads.setText(HIDE_THREADS_TEXT);
        } else {
            this.showHideThreads.setText(SHOW_THREADS_TEXT);
        }
    }
}

