/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Color;

public class GenericEventView
extends EventView {
    private final Color color;

    public GenericEventView(Visualization visualization, Explanation explanation) {
        super(visualization, explanation);
        EventKind kind = visualization.getTrace().getKind(explanation.getEventID());
        this.color = kind.isInvocation ? UI.CONTROL_COLOR : (kind.isBranch ? UI.CONTROL_COLOR : (kind == EventKind.EXCEPTION_CAUGHT ? UI.CONTROL_COLOR : (kind == EventKind.EXCEPTION_THROWN ? UI.CONTROL_COLOR : (kind == EventKind.RETURN ? UI.DATA_COLOR : (kind.isDefinition ? UI.DATA_COLOR : (kind == EventKind.NEW_OBJECT ? UI.DATA_COLOR : UI.DATA_COLOR))))));
    }

    public String determineFirstLine() {
        String label = this.visualization.getTrace().getDescription(this.getEventID());
        int index = Util.findStringSplitIndex(label);
        if (index >= 0) {
            return label.substring(0, index);
        }
        return label;
    }

    public String determineSecondLine() {
        String label = this.visualization.getTrace().getDescription(this.getEventID());
        int index = Util.findStringSplitIndex(label);
        if (index >= 0) {
            return label.substring(index);
        }
        return null;
    }

    protected Color determineBorderColor() {
        return this.color;
    }
}

