/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.ExplanationBlock;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.EventBlockView;
import edu.cmu.hcii.whyline.ui.qa.ThreadBlockView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventView
extends View
implements Comparable<EventView> {
    protected final Visualization visualization;
    private final Explanation explanation;
    private GlyphVector firstLineGlyphs;
    private GlyphVector secondLineGlyphs;
    protected double widthOfLabel;
    protected double widthOfFirstLine;
    protected double widthOfSecondLine;
    protected double heightOfLabel;
    private boolean hidden = false;
    private boolean familiar = true;
    private boolean initialized = false;
    protected boolean ancestorIsCollapsed = false;
    private boolean followsHiddenEvents = false;

    public EventView(Visualization visualization, Explanation explanation) {
        this.visualization = visualization;
        this.explanation = explanation;
        visualization.associateExplanationWithView(explanation, this);
        this.updateDescription();
    }

    public final void initializeVisibility() {
        if (this.isInitialized()) {
            return;
        }
        this.setHidden(this.isHiddenInitially());
        this.setFamiliar(this.isFamiliarInitially());
    }

    protected boolean isHiddenInitially() {
        return true;
    }

    protected boolean isFamiliarInitially() {
        return this.visualization.getTrace().classIsReferencedInFamiliarSourceFile(this.visualization.getTrace().getInstruction(this.explanation.getEventID()).getClassfile().getInternalName());
    }

    protected void setFamiliar(boolean familiar) {
        this.familiar = familiar;
    }

    protected void paintSelectionBorder(Graphics2D g) {
        Stroke stroke = g.getStroke();
        g.setStroke(UI.SELECTED_STROKE);
        this.drawRoundBoundaries(UI.getHighlightColor(), g, UI.getRoundedness(), UI.getRoundedness());
        g.setStroke(stroke);
    }

    public void setHidden(boolean hidden) {
        boolean changed = this.hidden ^ hidden;
        this.hidden = hidden;
        if (changed) {
            EventBlockView<?> blockView = this.getBlockView();
            if (blockView != null) {
                blockView.numberOfVisibleBlockChildren = blockView.numberOfVisibleBlockChildren + (hidden ? -1 : 1);
            }
            this.updateDescription();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isFamiliar() {
        return this.familiar;
    }

    protected final boolean isInitialized() {
        boolean i = this.initialized;
        if (!i) {
            this.initialized = true;
        }
        return i;
    }

    protected final void updateDescription() {
        String first = this.determineFirstLine();
        Graphics2D g = (Graphics2D)this.visualization.getWhylineUI().getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.firstLineGlyphs = UI.getSmallFont().createGlyphVector(g.getFontRenderContext(), first);
        String second = this.determineSecondLine();
        if (second != null) {
            this.secondLineGlyphs = UI.getSmallFont().createGlyphVector(g.getFontRenderContext(), second);
        }
        Rectangle2D firstLineBounds = this.firstLineGlyphs.getLogicalBounds();
        Rectangle2D secondLineBounds = this.secondLineGlyphs == null ? null : this.secondLineGlyphs.getLogicalBounds();
        this.widthOfFirstLine = firstLineBounds.getWidth();
        this.widthOfSecondLine = secondLineBounds == null ? 0.0 : secondLineBounds.getWidth();
        this.widthOfLabel = Math.max(this.widthOfFirstLine, this.widthOfSecondLine);
        this.heightOfLabel = firstLineBounds.getHeight() + (secondLineBounds == null ? 0.0 : secondLineBounds.getHeight());
        if (this.isHidden()) {
            this.setLocalWidth(0.0, false);
            this.setLocalHeight(0.0, false);
        } else {
            this.setLocalWidth(this.widthOfLabel + 8.0, false);
            this.setLocalHeight(this.heightOfLabel + 8.0, false);
        }
    }

    public abstract String determineFirstLine();

    public abstract String determineSecondLine();

    protected abstract Color determineBorderColor();

    protected GlyphVector getFirstLineGlyphs() {
        return this.firstLineGlyphs;
    }

    public EventBlockView<?> getBlockView() {
        View parent = this.getParent();
        if (parent instanceof EventBlockView) {
            return (EventBlockView)parent;
        }
        return null;
    }

    public ThreadBlockView getThreadBlockView() {
        EventBlockView<?> parent = this.getBlockView();
        while (parent != null && !(parent instanceof ThreadBlockView)) {
            parent = parent.getBlockView();
        }
        return (ThreadBlockView)parent;
    }

    public EventBlockView<?> getNearestVisibleBlockView() {
        EventBlockView<?> parent = this.getBlockView();
        while (parent != null && (parent.isCollapsed() || parent.isHidden())) {
            parent = parent.getBlockView();
        }
        return parent;
    }

    protected void markAncestorIsCollapsed(boolean isCollapsed) {
        this.ancestorIsCollapsed = isCollapsed;
    }

    public final boolean ancestorIsCollapsed() {
        return this.ancestorIsCollapsed;
    }

    public final EventBlockView<?> getEldestCollapsedAncestor() {
        EventBlockView<?> blockView = this.getBlockView();
        if (blockView == null) {
            return null;
        }
        if (blockView.ancestorIsCollapsed()) {
            return blockView.getEldestCollapsedAncestor();
        }
        if (blockView.isCollapsed()) {
            return blockView;
        }
        return null;
    }

    public double getLabelOffset() {
        return this.widthOfLabel + 4.0;
    }

    public double getWidthBasedOnBlocksCollapsedState() {
        return this.ancestorIsCollapsed() ? 0.0 : (this.isHidden() ? 0.0 : this.widthOfLabel + 8.0);
    }

    public double getAppropriateTop() {
        return (this.getParent().getLocalHeight() - this.getLocalHeight()) / 2.0;
    }

    public final Explanation getExplanation() {
        return this.explanation;
    }

    public final int getEventID() {
        return this.explanation.getEventID();
    }

    public int getGlobalSelectionPointX() {
        return (int)(this.getGlobalLeft() + this.getGlobalWidth() / 2.0);
    }

    public int getGlobalSelectionPointY() {
        return (int)(this.getGlobalTop() + this.getGlobalHeight() / 2.0);
    }

    public int getGlobalXToPointTo() {
        return (int)this.getGlobalLeft();
    }

    public int getGlobalYToPointTo() {
        return (int)(this.getGlobalTop() + this.getGlobalHeight() / 2.0);
    }

    public boolean containsGlobalTimeControllerX(int timeControllerX) {
        return (double)timeControllerX >= this.getGlobalLeft() && (double)timeControllerX <= this.getGlobalRight();
    }

    public boolean needsToBeExplained() {
        return !(this.explanation instanceof ExplanationBlock) && this.explanation.needsToBeExplained();
    }

    public void setAppearsAfterHiddenEvent(boolean follows) {
        this.followsHiddenEvents = follows;
    }

    @Override
    public void paintBelowChildren(Graphics2D g) {
        if (!this.isHidden() && (this.followsHiddenEvents || this.needsToBeExplained())) {
            double diametersPerDot = 4.0;
            int diameter = 4;
            int space = 60;
            int rightEdge = (int)this.getVisibleLocalLeft();
            int leftEdge = rightEdge - space;
            int y = (int)(this.getVisibleLocalTop() + this.getVisibleLocalHeight() / 2.0 - (double)(diameter / 2));
            int count = (int)((double)(space - 2 * diameter) / ((double)diameter * diametersPerDot));
            g.setColor(UI.getControlTextColor());
            leftEdge = (int)((double)leftEdge + (double)diameter * (diametersPerDot / 2.0 + 1.0));
            int i = 0;
            while (i < count) {
                g.fillOval(leftEdge, y, diameter, diameter);
                leftEdge = (int)((double)leftEdge + (double)diameter * diametersPerDot);
                ++i;
            }
        }
    }

    @Override
    public void paintAboveChildren(Graphics2D g) {
        if (!this.isHidden()) {
            if (this.visualization.getSelectedEventView() == this) {
                this.paintSelectionBorder(g);
            } else {
                Color color = this.determineBorderColor();
                if (color != null) {
                    this.drawRoundBoundaries(color, g, UI.getRoundedness(), UI.getRoundedness());
                }
            }
            g.setColor(UI.getControlTextColor());
            g.setFont(UI.getSmallFont());
            if (!this.familiar) {
                this.paintCrosshatch(g, (int)this.getVisibleLocalWidth());
            }
            this.paintLabel(g);
        }
    }

    protected void paintCrosshatch(Graphics2D g, int width) {
        g = (Graphics2D)g.create();
        int top = (int)this.getVisibleLocalTop();
        int left = (int)this.getVisibleLocalLeft();
        int height = (int)this.getVisibleLocalHeight();
        int stoppingPoint = left + width;
        if (this.getNumberOfChildren() > 0) {
            stoppingPoint = (int)((double)left + this.getFirstChild().getLocalLeft());
        }
        g.setComposite(AlphaComposite.getInstance(3, 0.25f));
        Util.drawCrosshatch(g, Color.black, left, stoppingPoint, top, height, UI.getCrosshatchSpacing(), 0);
    }

    protected void paintLabel(Graphics2D g) {
        float y = (int)(this.getVisibleLocalBottom() - (this.getVisibleLocalHeight() - this.heightOfLabel) / 2.0) - 3;
        if (this.secondLineGlyphs == null) {
            g.drawGlyphVector(this.firstLineGlyphs, (int)this.getVisibleLocalLeft() + 4, y);
        } else {
            g.drawGlyphVector(this.firstLineGlyphs, (int)this.getVisibleLocalLeft() + 4 + (int)(this.widthOfLabel - this.widthOfFirstLine) / 2, y - (float)((int)(this.heightOfLabel / 2.0)));
            g.drawGlyphVector(this.secondLineGlyphs, (int)this.getVisibleLocalLeft() + 4 + (int)(this.widthOfLabel - this.widthOfSecondLine) / 2, y);
        }
    }

    @Override
    public int compareTo(EventView view) {
        int thisViewsEvent = this.explanation.getEventID();
        int otherViewsEvent = view.explanation.getEventID();
        if (this != view && thisViewsEvent == otherViewsEvent) {
            return this.explanation.getBlockDepth() - view.explanation.getBlockDepth();
        }
        return thisViewsEvent - otherViewsEvent;
    }

    private boolean pointIsOverLabel(int x, int y) {
        return (double)x < this.getLocalLeft() + this.widthOfLabel + 8.0;
    }

    @Override
    public boolean handleMouseDown(int localX, int localY, int mouseButton) {
        if (!this.isHidden() && this.pointIsOverLabel(localX, localY)) {
            this.visualization.getVisualizationUI().setSelection(this, false, "click");
            return true;
        }
        return false;
    }

    public int getRow() {
        return this.getEventID() < 0 ? -1 : this.visualization.getRowForThread(this.visualization.getTrace().getThreadID(this.getEventID()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + (this.getEventID() < 0 ? "" : this.visualization.getTrace().eventToString(this.getEventID())) + ")";
    }
}

