/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Color;

public class ArgumentEventView
extends EventView {
    public ArgumentEventView(Visualization visualization, Explanation explanation) {
        super(visualization, explanation);
        this.setLocalHeight(this.heightOfLabel, false);
    }

    public boolean isLastVisibleArgument() {
        View childAfter = this.getChildAfter();
        if (this.isHidden()) {
            return false;
        }
        if (!(childAfter instanceof ArgumentEventView)) {
            return true;
        }
        return !((ArgumentEventView)childAfter).isLastVisibleArgument();
    }

    public String determineFirstLine() {
        String name = this.visualization.getTrace().getArgumentNameSet(this.getEventID());
        if (name == null) {
            return "=";
        }
        return String.valueOf(Util.elide(name, 12)) + " =";
    }

    public String determineSecondLine() {
        return Util.elide(this.visualization.getTrace().getArgumentValueDescription(this.getEventID()), 12);
    }

    protected Color determineBorderColor() {
        return UI.DATA_COLOR;
    }
}

