/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.io.GraphicalEventAppearance;
import edu.cmu.hcii.whyline.io.WindowState;
import edu.cmu.hcii.whyline.qa.GraphicsMenuFactory;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.io.GraphicsUI;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowView
extends View {
    private final GraphicsUI graphicsUI;
    private final WhylineUI whylineUI;
    public static final int TITLE_HEIGHT = 20;
    private int currentEventID;
    private BufferedImage currentImage;
    private final WindowState windowState;
    private SortedSet<GraphicalEventAppearance> eventsUnderMouse = new TreeSet<GraphicalEventAppearance>();

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public WindowView(GraphicsUI graphicsUI, WindowState windowState) {
        this.graphicsUI = graphicsUI;
        this.whylineUI = graphicsUI.getWhylineUI();
        this.windowState = windowState;
    }

    public SortedSet<GraphicalEventAppearance> getEventsUnderMouse() {
        return this.eventsUnderMouse;
    }

    public GraphicalEventAppearance getEventUnderMouse() {
        return this.eventsUnderMouse.size() > 0 ? this.eventsUnderMouse.last() : null;
    }

    public void setCurrentEventID(int newEventID) {
        this.currentEventID = newEventID;
        this.updateSize();
    }

    public void updateSize() {
        int maxWidth = this.windowState.getMaxWidth();
        int maxHeight = this.windowState.getMaxHeight();
        if (this.currentImage != null && (maxWidth > this.currentImage.getWidth() || maxHeight > this.currentImage.getHeight())) {
            this.currentImage = null;
        }
        if (this.currentImage == null) {
            this.currentImage = new BufferedImage(maxWidth, maxHeight, 2);
        }
        Rectangle newSize = this.windowState.drawWindowAtEventID(this.currentEventID, this.currentImage);
        this.setLocalLeft(newSize.x, false);
        this.setLocalTop(newSize.y, false);
        this.setLocalWidth(newSize.width, false);
        this.setLocalHeight(newSize.height + 20, false);
        this.repaint();
    }

    @Override
    public void paintBelowChildren(Graphics2D g) {
        g = (Graphics2D)g.create();
        g.setColor(UI.getPanelDarkColor());
        g.fillRoundRect((int)this.getLocalLeft(), (int)this.getLocalTop(), (int)this.getLocalWidth(), 40, UI.getRoundedness(), UI.getRoundedness());
        g.setColor(UI.getPanelLightColor());
        g.drawRoundRect((int)this.getLocalLeft(), (int)this.getLocalTop(), (int)this.getLocalWidth(), 40, UI.getRoundedness(), UI.getRoundedness());
        g.setColor(UI.getPanelTextColor());
        g.setFont(UI.getMediumFont().deriveFont(1));
        g.drawString(this.whylineUI.getTrace().getDescriptionOfObjectID(this.windowState.getWindowID()), (int)this.getLocalLeft() + 5, (int)this.getLocalTop() + 20 - 5);
        if (this.currentImage != null) {
            Graphics2D clipped = (Graphics2D)g.create();
            clipped.clipRect((int)this.getLocalLeft(), (int)this.getLocalTop() + 20, (int)this.getLocalWidth() + 1, (int)this.getLocalHeight() + 1 - 20);
            clipped.drawImage((Image)this.currentImage, (int)this.getLocalLeft(), (int)this.getLocalTop() + 20, null);
        }
        g.setColor(UI.getControlBorderColor());
        g.drawRect((int)this.getLocalLeft(), (int)(this.getLocalTop() + 20.0), (int)this.getLocalWidth(), (int)(this.getLocalHeight() - 20.0));
    }

    private boolean canUpdateSelection() {
        return !this.whylineUI.userIsAskingQuestion() && this.whylineUI.canAskOutputQuestions();
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    @Override
    public boolean handleMouseMove(int x, int y) {
        if (this.whylineUI.getVisualizationUIVisible() != null) {
            return false;
        }
        if (!this.canUpdateSelection()) {
            return false;
        }
        this.eventsUnderMouse = this.windowState.getRenderEventsAtLocationAfterEventID((int)((double)x - this.getLocalLeft()), (int)((double)y - this.getLocalTop() - 20.0), this.currentEventID);
        if (!this.eventsUnderMouse.isEmpty()) {
            this.graphicsUI.setHighlight(this.getEventUnderMouse());
        }
        return !this.eventsUnderMouse.isEmpty();
    }

    @Override
    public boolean handleMouseDrag(int x, int y, int button) {
        this.setLocalLeft(x - this.getContainer().getMouseFocusX(), false);
        this.setLocalTop(y - this.getContainer().getMouseFocusY(), false);
        this.repaint();
        return true;
    }

    @Override
    public boolean handleMouseUp(int x, int y, int button) {
        this.getContainer().releaseMouseFocus();
        return true;
    }

    @Override
    public boolean handleMouseClick(int localX, int localY, int mouseButton) {
        if (!this.whylineUI.getTrace().isDoneLoading()) {
            return false;
        }
        if (this.whylineUI.getVisualizationUIVisible() != null) {
            return false;
        }
        if (!this.whylineUI.isWhyline()) {
            return false;
        }
        if ((double)localX >= this.getLocalLeft() && (double)localX <= this.getLocalRight() && (double)localY >= this.getLocalTop() && (double)localY <= this.getLocalTop() + 20.0) {
            this.bringToFront();
            this.getContainer().focusMouseOn(this);
            return true;
        }
        if (!this.canUpdateSelection()) {
            return false;
        }
        if (mouseButton != 1) {
            return false;
        }
        Point2D point = this.localToGlobal(new Point2D.Double((double)localX - this.getLocalLeft(), (double)localY - this.getLocalTop()));
        QuestionMenu questionMenu = GraphicsMenuFactory.getQuestionMenu(this.whylineUI, this.getEventsUnderMouse());
        if (questionMenu == null) {
            return false;
        }
        WhylinePopup menu = questionMenu.generatePopupMenu();
        return this.getContainer().showPopup(menu, (int)point.getX(), (int)point.getY());
    }

    @Override
    public void handleMouseExit() {
        if (!this.canUpdateSelection()) {
            return;
        }
        this.eventsUnderMouse.clear();
        this.repaint();
    }
}

