/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.io.GetGraphicsOutputEvent;
import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.io.KeyStateInputEvent;
import edu.cmu.hcii.whyline.io.MouseStateInputEvent;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.TextualOutputEvent;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserFocusListener;
import edu.cmu.hcii.whyline.ui.UserQuestionListener;
import edu.cmu.hcii.whyline.ui.UserTimeListener;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.qa.EventView;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import edu.cmu.hcii.whyline.ui.views.DynamicComponent;
import edu.cmu.hcii.whyline.ui.views.View;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeUI
extends DynamicComponent
implements UserQuestionListener,
UserTimeListener,
UserFocusListener {
    private final WhylineUI whylineUI;
    private BufferedImage ioEventMarkers;
    private double progress = 0.0;
    private static final int BUTTON_PADDING = 6;
    private final IOButton repaint;
    private final IOButton move;
    private final IOButton drag;
    private final IOButton press;
    private final IOButton release;
    private final IOButton print;
    private final IOButton read;
    private final IOButton scroll;
    private final IOButton keyup;
    private final IOButton keydown;
    private IOButton selection = null;
    private final View controller = new View(){

        public boolean handleMouseDown(int localX, int localY, int mouseButton) {
            this.getContainer().focusMouseOn(this);
            return this.handleMouseDrag(localX, localY, mouseButton);
        }

        public boolean handleMouseDrag(int localX, int localY, int mouseButton) {
            if (TimeUI.this.breakpointDebuggerIsRunning()) {
                return false;
            }
            if (TimeUI.this.whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT) {
                int time = (int)((double)localX / this.getLocalWidth() * (double)TimeUI.this.whylineUI.getTrace().getNumberOfEvents());
                TimeUI.this.whylineUI.setInputTime(time);
                TimeUI.this.whylineUI.getBreakpointDebugger().setPauseMode(true);
            } else {
                int time = (int)((double)localX / this.getLocalWidth() * (double)TimeUI.this.whylineUI.getTrace().getNumberOfEvents());
                IOEvent io = TimeUI.this.whylineUI.getTrace().getIOHistory().getMostRecentBeforeTime(time);
                if (TimeUI.this.whylineUI.isQuestionVisible()) {
                    Answer answer = TimeUI.this.whylineUI.getVisualizationUIVisible().getAnswer();
                    if (io != null && answer != null) {
                        Explanation explanation = answer.getExplanationFor(io.getEventID());
                        answer.broadcastChanges();
                        if (explanation != null) {
                            TimeUI.this.whylineUI.selectExplanation(explanation, false, "time");
                        }
                    }
                } else {
                    TimeUI.this.setInputOutputTimes(TimeUI.this.determineSelectableIOEventAtOrBefore(io));
                }
            }
            return true;
        }

        public boolean handleMouseUp(int localX, int localY, int mouseButton) {
            this.getContainer().releaseMouseFocus();
            return true;
        }

        public boolean handleKeyPressed(KeyEvent e) {
            if (TimeUI.this.breakpointDebuggerIsRunning()) {
                return false;
            }
            Trace trace = TimeUI.this.whylineUI.getTrace();
            if (e.getKeyCode() == 37) {
                IOEvent ioEvent = TimeUI.this.whylineUI.getTrace().getIOHistory().getMostRecentBeforeTime(TimeUI.this.whylineUI.getInputEventID() - 1);
                TimeUI.this.setInputOutputTimes(TimeUI.this.determineSelectableIOEventAtOrBefore(ioEvent));
                return true;
            }
            if (e.getKeyCode() == 39) {
                TimeUI.this.setInputOutputTimes(TimeUI.this.determineSelectableIOEventAfter(TimeUI.this.whylineUI.getEventAtInputTime()));
                return true;
            }
            return false;
        }

        public void paintBelowChildren(Graphics2D g) {
            g = (Graphics2D)g.create();
            int left = (int)TimeUI.this.convertEventIndexToPosition(TimeUI.this.whylineUI.getInputEventID());
            int right = (int)TimeUI.this.convertEventIndexToPosition(TimeUI.this.whylineUI.getOutputEventID());
            int scopeLeft = left;
            int scopeRight = right;
            if (TimeUI.this.whylineUI.isQuestionVisible()) {
                scopeLeft = (int)TimeUI.this.convertEventIndexToPosition(TimeUI.this.whylineUI.getQuestionVisible().getInputEventID());
                scopeRight = (int)TimeUI.this.convertEventIndexToPosition(TimeUI.this.whylineUI.getQuestionVisible().getOutputEventID());
            }
            int verticalCenter = (int)(this.getLocalHeight() / 2.0);
            int boxWidth = (int)(this.getLocalHeight() / 4.0);
            Color lockedColor = Color.lightGray;
            Color draggingColor = Color.white;
            Color setColor = UI.getHighlightColor();
            Paint oldPaint = g.getPaint();
            Composite oldComposite = g.getComposite();
            if (TimeUI.this.whylineUI.getQuestionOver() != null) {
                int w;
                int x;
                Question<?> q = TimeUI.this.whylineUI.getQuestionOver();
                if (q.isPhrasedNegatively()) {
                    x = scopeLeft;
                    w = scopeRight - scopeLeft;
                } else {
                    x = 0;
                    w = scopeLeft;
                }
                g.setColor(UI.getHighlightColor());
                g.fillRect(x, 0, w, (int)this.getLocalHeight());
                g.setColor(UI.getHighlightTextColor());
            }
            g.setColor(TimeUI.this.breakpointDebuggerIsRunning() ? UI.getRunningColor() : UI.getControlTextColor());
            g.fillRoundRect(scopeLeft, 0, 4, (int)this.getLocalHeight(), 5, 5);
            g.setComposite(oldComposite);
            g.setPaint(oldPaint);
            if (TimeUI.this.whylineUI.isQuestionVisible()) {
                g.setColor(UI.getControlTextColor());
                g.setStroke(UI.SELECTED_STROKE);
                g.drawLine(left, 0, left, (int)this.getLocalHeight());
                VisualizationUI viz = TimeUI.this.whylineUI.getVisualizationUIVisible();
                if (viz != null && viz.getSelection() instanceof EventView) {
                    int eventID = ((EventView)viz.getSelection()).getEventID();
                    left = (int)TimeUI.this.convertEventIndexToPosition(eventID);
                }
                g.setColor(UI.getHighlightColor());
                g.setStroke(UI.SELECTED_STROKE);
                g.drawLine(left, 0, left, (int)this.getLocalHeight());
            }
            if (!TimeUI.this.isMinimized()) {
                g.setColor(UI.getControlTextColor());
                int inputEventID = TimeUI.this.whylineUI.getInputEventID();
                IOEvent ioEvent = TimeUI.this.whylineUI.getEventAtInputTime();
                String eventDescription = inputEventID == 0 ? "program started..." : (ioEvent == null ? "" : ioEvent.getHTMLDescription());
                boolean negative = false;
                if (TimeUI.this.whylineUI.getQuestionOver() != null) {
                    negative = TimeUI.this.whylineUI.getQuestionOver().isPhrasedNegatively();
                    eventDescription = String.valueOf(negative ? "after this " : "before this ") + eventDescription + "...";
                }
                g.setFont(UI.getSmallFont());
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(eventDescription, g);
                int labelX = (int)(negative ? (double)scopeLeft - bounds.getWidth() - 10.0 : (double)(scopeLeft + 10));
                labelX = Math.max(0, labelX);
                labelX = (int)Math.min((double)labelX, (double)((int)this.getLocalWidth()) - bounds.getWidth() - 10.0);
                g.drawString(eventDescription, labelX, (int)this.getLocalBottom() - 10);
                int filterMessageX = (int)(this.getLastChild().getLocalRight() + (double)UI.getPanelPadding());
                int filterMessageY = (int)this.getLastChild().getLocalBottom();
                g.setColor(UI.getControlTextColor());
                g.setFont(UI.getSmallFont());
                g.drawString(TimeUI.this.selection == null ? "showing all i/o events" : "only showing " + TimeUI.this.selection.description, filterMessageX, filterMessageY);
            }
        }

        public void paintAboveChildren(Graphics2D g) {
            if (TimeUI.this.whylineUI.isWhyline()) {
                if (TimeUI.this.ioEventMarkers == null) {
                    TimeUI.this.redrawIOEventMarkers();
                }
                g.drawImage((Image)TimeUI.this.ioEventMarkers, 0, 0, null);
            }
        }

        public void handleContainerResize() {
            TimeUI.this.redrawIOEventMarkers();
        }
    };
    private Timer flasher;
    private double flashingAmount = 0.0;
    private int flashingFrequency = 75;

    public TimeUI(WhylineUI whylineUI) {
        super(whylineUI, DynamicComponent.Sizing.FIT, DynamicComponent.Sizing.FIT);
        this.whylineUI = whylineUI;
        this.setView(this.controller);
        this.move = new IOButton("mouse move events", UI.MOUSE_MOVE_ICON, (UI.ICON_SIZE + 6) * 0);
        this.drag = new IOButton("mouse drag events", UI.MOUSE_DRAG_ICON, (UI.ICON_SIZE + 6) * 1);
        this.press = new IOButton("mouse press events", UI.MOUSE_DOWN_ICON, (UI.ICON_SIZE + 6) * 2);
        this.release = new IOButton("mouse release events", UI.MOUSE_UP_ICON, (UI.ICON_SIZE + 6) * 3);
        this.scroll = new IOButton("scroll wheel events", UI.MOUSE_WHEEL_ICON, (UI.ICON_SIZE + 6) * 4);
        this.keyup = new IOButton("key up events", UI.KEY_UP_ICON, (UI.ICON_SIZE + 6) * 5);
        this.keydown = new IOButton("key down events", UI.KEY_DOWN_ICON, (UI.ICON_SIZE + 6) * 6);
        this.repaint = new IOButton("repaint events", UI.REPAINT_ICON, (UI.ICON_SIZE + 6) * 7);
        this.print = new IOButton("print to console events", UI.CONSOLE_OUT_ICON, (UI.ICON_SIZE + 6) * 8);
        this.read = new IOButton("read from console events", UI.CONSOLE_IN_ICON, (UI.ICON_SIZE + 6) * 9);
        this.controller.addChild(this.move);
        this.controller.addChild(this.drag);
        this.controller.addChild(this.press);
        this.controller.addChild(this.release);
        this.controller.addChild(this.scroll);
        this.controller.addChild(this.keyup);
        this.controller.addChild(this.keydown);
        this.controller.addChild(this.repaint);
        this.controller.addChild(this.print);
        this.controller.addChild(this.read);
        this.updateSize();
        this.setToolTipText(whylineUI.isWhyline() ? "Drag or use \u2190 and \u2192 to explore <b>I/O events</b>" : "<html>Represents the program execution, from start to finish.<br>Drag to see the state of program output at different times");
    }

    public void setProgress(double percent) {
        this.progress = percent;
        this.repaint();
    }

    private double convertEventIndexToPosition(long eventIndex) {
        int numberOfEvents = this.whylineUI.getTrace().getNumberOfEvents();
        return (double)eventIndex / (double)numberOfEvents * this.controller.getLocalWidth();
    }

    private void redrawIOEventMarkers() {
        if (!this.whylineUI.getTrace().isDoneLoading()) {
            return;
        }
        this.ioEventMarkers = new BufferedImage((int)Math.max(1.0, this.controller.getLocalWidth()), (int)Math.max(1.0, this.controller.getLocalHeight()), 2);
        Graphics2D g = (Graphics2D)this.ioEventMarkers.getGraphics();
        int verticalCenter = (int)this.controller.getLocalHeight() / 2;
        int maxTime = this.whylineUI.getTrace().getNumberOfEvents();
        g.setColor(UI.getControlTextColor());
        for (IOEvent event : this.whylineUI.getTrace().getIOHistory()) {
            if (!event.segmentsOutput() || !this.ioEventIsOfDesiredType(event)) continue;
            int left = (int)this.convertEventIndexToPosition(event.getEventID());
            g.fillRect(left, verticalCenter, 2, 2);
        }
    }

    private boolean breakpointDebuggerIsRunning() {
        return this.whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT && this.whylineUI.getBreakpointDebugger().isRunning();
    }

    private void setInputOutputTimes(IOEvent inputEvent) {
        IOEvent outputEvent = this.determineSelectableIOEventAfter(inputEvent);
        this.whylineUI.setInputTime(inputEvent == null ? 0 : inputEvent.getEventID());
        this.whylineUI.setOutputTime(this.whylineUI.getTrace().getNumberOfEvents() - 1);
    }

    private IOEvent determineSelectableIOEventAfter(IOEvent event) {
        if (event == this.whylineUI.getTrace().getIOHistory().getLastEvent()) {
            return event;
        }
        for (IOEvent io : this.whylineUI.getTrace().getIOHistory().getIteratorForEventsAfter(event)) {
            if (!io.segmentsOutput() || !this.ioEventIsOfDesiredType(io)) continue;
            return io;
        }
        return event;
    }

    private IOEvent determineSelectableIOEventAtOrBefore(IOEvent event) {
        if (event == null) {
            return event;
        }
        if (event.segmentsOutput() && this.ioEventIsOfDesiredType(event)) {
            return event;
        }
        for (IOEvent io : this.whylineUI.getTrace().getIOHistory().getIteratorForEventsBefore(event)) {
            if (!io.segmentsOutput() || !this.ioEventIsOfDesiredType(io)) continue;
            return io;
        }
        return null;
    }

    @Override
    public void questionChanged(Question<?> question) {
        this.updateSize();
    }

    public boolean isMinimized() {
        return !this.whylineUI.isWhyline() || this.whylineUI.getQuestionVisible() != null;
    }

    private void updateSize() {
        this.setPreferredSize(new Dimension(0, this.isMinimized() ? 33 : 100));
        this.revalidate();
    }

    @Override
    public void inputTimeChanged(int time) {
        this.repaint();
    }

    @Override
    public void outputTimeChanged(int time) {
        this.repaint();
    }

    @Override
    public int getHorizontalScrollIncrement() {
        return 0;
    }

    @Override
    public int getVerticalScrollIncrement() {
        return 0;
    }

    public boolean ioEventIsOfDesiredType(IOEvent io) {
        if (this.selection == null) {
            return true;
        }
        if (io instanceof MouseStateInputEvent) {
            MouseStateInputEvent mouseEvent = (MouseStateInputEvent)io;
            int id = mouseEvent.getType();
            switch (id) {
                case 501: {
                    return this.selection == this.press;
                }
                case 506: {
                    return this.selection == this.drag;
                }
                case 500: 
                case 502: {
                    return this.selection == this.release;
                }
                case 507: {
                    return this.selection == this.scroll;
                }
                case 503: {
                    return this.selection == this.move;
                }
            }
            return false;
        }
        if (io instanceof KeyStateInputEvent) {
            KeyStateInputEvent keyEvent = (KeyStateInputEvent)io;
            int type = keyEvent.getType();
            switch (type) {
                case 401: {
                    return this.selection == this.keydown;
                }
                case 402: {
                    return this.selection == this.keyup;
                }
                case 400: {
                    return this.selection == this.keyup;
                }
            }
            return false;
        }
        if (this.selection == this.repaint) {
            return io instanceof GetGraphicsOutputEvent;
        }
        if (this.selection == this.print) {
            return io instanceof TextualOutputEvent;
        }
        return false;
    }

    public void selectButtonBasedOnTrace() {
        Trace trace = this.whylineUI.getTrace();
        this.selection = null;
        this.validate();
        this.repaint();
    }

    @Override
    public void showEvent(int eventID) {
        if (!this.whylineUI.isQuestionVisible()) {
            return;
        }
        IOEvent e = this.whylineUI.getTrace().getIOHistory().getMostRecentBeforeTime(eventID);
        if (e instanceof RenderEvent) {
            this.whylineUI.setInputTime(e == null ? 0 : e.getEventID());
        }
        this.repaint();
    }

    @Override
    public void showExplanation(Explanation subject) {
        this.showEvent(subject.getEventID());
    }

    @Override
    public void showFile(FileInterface subject) {
    }

    @Override
    public void showInstruction(Instruction subject) {
    }

    @Override
    public void showInstructions(Iterable<? extends Instruction> subject) {
    }

    @Override
    public void showMethod(MethodInfo subject) {
    }

    @Override
    public void showClass(Classfile subject) {
    }

    @Override
    public void showUnexecutedInstruction(UnexecutedInstruction subject) {
    }

    private double getPercentFlash() {
        return Math.abs(Math.sin(Math.PI * this.flashingAmount / 180.0));
    }

    public void startFlashingMessage() {
        if (this.flasher != null) {
            return;
        }
        this.flasher = new Timer("Flasher", true);
        this.flasher.schedule(new TimerTask(){

            public void run() {
                TimeUI timeUI = TimeUI.this;
                timeUI.flashingAmount = timeUI.flashingAmount + (double)(180 / (1000 / TimeUI.this.flashingFrequency));
                if (TimeUI.this.flashingAmount > 180.0) {
                    TimeUI.this.flashingAmount = 0.0;
                }
                TimeUI.this.repaint();
            }
        }, 0L, (long)this.flashingFrequency);
    }

    public void stopFlashingMessage() {
        if (this.flasher != null) {
            this.flasher.cancel();
        }
        this.flasher = null;
    }

    private class IOButton
    extends View {
        private final ImageIcon icon;
        private final String description;

        public IOButton(String description, ImageIcon icon, int left) {
            this.description = description;
            this.icon = icon;
            this.setLocalLeft(left + 6, false);
            this.setLocalTop(6.0, false);
            this.setLocalWidth(UI.ICON_SIZE, false);
            this.setLocalHeight(UI.ICON_SIZE, false);
        }

        public boolean handleMouseDown(int x, int y, int button) {
            if (this.isDisabled()) {
                return false;
            }
            if (TimeUI.this.selection == this) {
                TimeUI.this.selection = null;
            } else {
                TimeUI.this.selection = this;
            }
            TimeUI.this.redrawIOEventMarkers();
            this.repaint();
            return true;
        }

        private boolean isDisabled() {
            return TimeUI.this.whylineUI.isQuestionVisible() || !TimeUI.this.whylineUI.isWhyline();
        }

        public void paintAboveChildren(Graphics2D g) {
            if (this.isDisabled()) {
                return;
            }
            Graphics2D scaled = (Graphics2D)g.create();
            if (TimeUI.this.selection != this) {
                scaled.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            this.icon.paintIcon(TimeUI.this, scaled, (int)this.getVisibleLocalLeft(), (int)this.getVisibleLocalTop());
        }
    }
}

