/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.io;

import edu.cmu.hcii.whyline.io.DrawCharacterSequenceEvent;
import edu.cmu.hcii.whyline.io.DrawCharsEvent;
import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.io.DrawStringEvent;
import edu.cmu.hcii.whyline.io.GetGraphicsOutputEvent;
import edu.cmu.hcii.whyline.io.GraphicalEventAppearance;
import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.io.KeyStateInputEvent;
import edu.cmu.hcii.whyline.io.MouseStateInputEvent;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.WindowState;
import edu.cmu.hcii.whyline.qa.GraphicsMenuFactory;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.UserTimeListener;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.io.WindowView;
import edu.cmu.hcii.whyline.ui.views.DynamicComponent;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.SortedSet;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphicsUI
extends DynamicComponent
implements UserTimeListener {
    private final WhylineUI whylineUI;
    private static final int SPACE_BETWEEN_WINDOWS = 10;
    private int selectedScale = 100;
    private final ArrayList<WindowView> windowViews = new ArrayList();
    private Named selection = null;
    private RenderEvent renderEventUnderMouse;
    private MouseStateInputEvent latestInput;
    private WindowView selectionWindow;
    private Shape selectionShape;
    private boolean selectionIsText;
    private final ChangeListener menuChangeListener;
    private final View windows = new View(){
        private double viewXOnDown;
        private double viewYOnDown;
        private double xOnDown;
        private double yOnDown;

        public void paintBelowChildren(Graphics2D g) {
            g.setColor(UI.getControlCenterColor().darker());
            int x = GraphicsUI.this.selectedScale;
            while ((double)x < this.getLocalWidth()) {
                g.drawLine(x, 0, x, (int)this.getLocalBottom());
                x += GraphicsUI.this.selectedScale;
            }
            int y = GraphicsUI.this.selectedScale;
            while ((double)y < this.getLocalHeight()) {
                g.drawLine(0, y, (int)this.getLocalRight(), y);
                y += GraphicsUI.this.selectedScale;
            }
        }

        public void paintAboveChildren(Graphics2D g) {
            MouseStateInputEvent latestMouseEvent;
            g = (Graphics2D)g.create();
            double scale = GraphicsUI.this.getScale();
            g.scale(scale, scale);
            Graphics2D selectionG = (Graphics2D)g.create();
            if (GraphicsUI.this.selectionShape != null && GraphicsUI.this.selectionWindow != null) {
                SortedSet<DrawImageEvent> drawImagesSkipped;
                Rectangle shapeBounds = GraphicsUI.this.selectionShape.getBounds();
                if (GraphicsUI.this.renderEventUnderMouse != null && GraphicsUI.this.renderEventUnderMouse.getRenderers() != null && (drawImagesSkipped = GraphicsUI.this.renderEventUnderMouse.getGraphicsState().getWindowState().getDrawImagesSkipped()).size() > 0) {
                    DrawImageEvent drawImage = drawImagesSkipped.first();
                    drawImage.transformContextToDrawPrimitive(selectionG);
                }
                selectionG.setColor(UI.getHighlightColor());
                selectionG.setStroke(GraphicsUI.this.selectionIsText ? new BasicStroke(2.0f) : UI.SELECTED_STROKE);
                int windowX = (int)GraphicsUI.this.selectionWindow.getLocalLeft();
                int windowY = (int)(GraphicsUI.this.selectionWindow.getLocalTop() + 20.0);
                selectionG.translate(windowX, windowY);
                selectionG.draw(GraphicsUI.this.selectionShape);
            }
            if ((latestMouseEvent = GraphicsUI.this.whylineUI.getTrace().getMouseHistory().getMostRecentBeforeTime(GraphicsUI.this.whylineUI.getInputEventID())) != null) {
                long source = latestMouseEvent.getSource();
                WindowView window = GraphicsUI.this.getViewOfWindowID(source);
                int mouseX = latestMouseEvent.getX() + (window == null ? 0 : (int)window.getLocalLeft());
                int mouseY = latestMouseEvent.getY() + (window == null ? 0 : (int)window.getLocalTop());
                g.translate(mouseX, mouseY);
                g.setColor(UI.getHighlightColor());
                g.fill(cursor);
                g.setColor(UI.getHighlightTextColor());
                g.draw(cursor);
                g.translate(-mouseX, -mouseY);
            }
            if (GraphicsUI.this.whylineUI.canAskOutputQuestions() && GraphicsUI.this.whylineUI.getVisualizationUIVisible() == null) {
                String label;
                IOEvent ioEvent = GraphicsUI.this.whylineUI.getEventAtInputTime();
                String string = label = ioEvent == null ? "after the program started" : "after this " + ioEvent.getHTMLDescription() + "...";
                if (GraphicsUI.this.whylineUI.getInputEventID() == 0) {
                    Util.drawCallout(g, null, label, 0, 0);
                } else if (ioEvent instanceof GetGraphicsOutputEvent) {
                    long windowID = ((GetGraphicsOutputEvent)ioEvent).getObjectID();
                    WindowView view = GraphicsUI.this.getViewOfWindowID(windowID);
                    if (view != null) {
                        Rectangle2D bounds = Util.getStringBounds(g, UI.getSmallFont(), label);
                        int x = (int)view.getLocalLeft();
                        int y = (int)view.getLocalBottom();
                        Util.drawCallout(g, UI.REPAINT_ICON, label, x, y);
                    }
                } else if (ioEvent instanceof KeyStateInputEvent) {
                    KeyStateInputEvent keyEvent = (KeyStateInputEvent)ioEvent;
                    long source = keyEvent.getSource();
                    WindowView window = GraphicsUI.this.getViewOfWindowID(source);
                    Rectangle2D bounds = Util.getStringBounds(g, UI.getSmallFont(), label);
                    int x = window == null ? 0 : (int)window.getLocalLeft();
                    int y = window == null ? 0 : (int)window.getLocalBottom();
                    Util.drawCallout(g, keyEvent.getType() == 401 ? UI.KEY_DOWN_ICON : UI.KEY_UP_ICON, label, x, y);
                } else if (ioEvent instanceof MouseStateInputEvent) {
                    MouseStateInputEvent mouseEvent = (MouseStateInputEvent)ioEvent;
                    long source = mouseEvent.getSource();
                    WindowView window = GraphicsUI.this.getViewOfWindowID(source);
                    int calloutX = window == null ? 0 : (int)window.getLocalLeft();
                    int calloutY = window == null ? 0 : (int)window.getLocalBottom();
                    ImageIcon iconToDraw = null;
                    int state = mouseEvent.getType();
                    if (state == 500) {
                        iconToDraw = UI.MOUSE_UP_ICON;
                    } else if (state == 506) {
                        iconToDraw = UI.MOUSE_DRAG_ICON;
                    } else if (state == 501) {
                        iconToDraw = UI.MOUSE_DOWN_ICON;
                    } else if (state == 502) {
                        iconToDraw = UI.MOUSE_DOWN_ICON;
                    } else if (state == 503 || state == 504 || state == 505) {
                        iconToDraw = UI.MOUSE_MOVE_ICON;
                    } else if (state == 507) {
                        iconToDraw = UI.MOUSE_WHEEL_ICON;
                    } else {
                        System.err.println("Not rendering " + state);
                    }
                    Util.drawCallout(g, iconToDraw, label, calloutX, calloutY);
                }
            }
            if (this.getNumberOfChildren() == 0 && GraphicsUI.this.whylineUI.getTrace().isDoneLoading()) {
                g.setFont(UI.getLargeFont());
                g.setColor(UI.getControlTextColor());
                g.drawString("The program didn't produce graphical output", 10, g.getFontMetrics(UI.getLargeFont()).getHeight() + 10);
            }
        }

        public boolean handleMouseDown(int localX, int localY, int mouseButton) {
            this.viewXOnDown = GraphicsUI.this.getViewportX();
            this.viewYOnDown = GraphicsUI.this.getViewportY();
            this.getContainer().focusMouseOn(this);
            this.xOnDown = localX - GraphicsUI.this.getViewportX();
            this.yOnDown = localY - GraphicsUI.this.getViewportY();
            return true;
        }

        public boolean handleMouseUp(int localX, int localY, int mouseButton) {
            this.getContainer().releaseMouseFocus();
            return true;
        }

        public boolean handleMouseDrag(int localX, int localY, int mouseButton) {
            double dx = this.xOnDown - (double)(localX - GraphicsUI.this.getViewportX());
            double dy = this.yOnDown - (double)(localY - GraphicsUI.this.getViewportY());
            GraphicsUI.this.setViewPosition((int)(this.viewXOnDown + dx), (int)(this.viewYOnDown + dy));
            this.repaint();
            return true;
        }

        public boolean handleWheelMove(int units) {
            GraphicsUI.this.whylineUI.setGraphicsScale(GraphicsUI.this.selectedScale - units);
            return true;
        }

        public void handleContainerResize() {
            GraphicsUI.this.updateScale();
        }

        public void handleMouseEnter() {
            GraphicsUI.this.setToolTipText("Click to ask about <b>paint</b> that didn't appear");
        }

        public boolean handleMouseMove(int x, int y) {
            GraphicsUI.this.removeHighlight();
            return true;
        }

        public boolean handleMouseClick(int x, int y, int button) {
            if (GraphicsUI.this.whylineUI.getVisualizationUIVisible() != null) {
                GraphicsUI.this.whylineUI.setQuestion(null);
                return true;
            }
            if (GraphicsUI.this.whylineUI.isWhyline()) {
                QuestionMenu whyDidntMenu = new QuestionMenu(GraphicsUI.this.whylineUI, "Questions about graphics that classes didn't paint", "questions");
                QuestionMenu questionMenu = GraphicsMenuFactory.getWindowQuestions(GraphicsUI.this.whylineUI);
                whyDidntMenu.addMenu(questionMenu);
                WhylinePopup menu = whyDidntMenu.generatePopupMenu();
                return GraphicsUI.this.showPopup(menu, x, y);
            }
            return true;
        }
    };
    private static final Polygon cursor = new Polygon();

    static {
        int RIGHT = 9;
        int BOTTOM = 15;
        cursor.addPoint((int)((double)RIGHT * 0.0), (int)((double)BOTTOM * 0.0));
        cursor.addPoint((int)((double)RIGHT * 1.0), (int)((double)BOTTOM * 0.6));
        cursor.addPoint((int)((double)RIGHT * 0.6), (int)((double)BOTTOM * 0.6));
        cursor.addPoint((int)((double)RIGHT * 0.85), (int)((double)BOTTOM * 0.95));
        cursor.addPoint((int)((double)RIGHT * 0.77), (int)((double)BOTTOM * 1.0));
        cursor.addPoint((int)((double)RIGHT * 0.6), (int)((double)BOTTOM * 1.0));
        cursor.addPoint((int)((double)RIGHT * 0.35), (int)((double)BOTTOM * 0.68));
        cursor.addPoint((int)((double)RIGHT * 0.0), (int)((double)BOTTOM * 0.9));
        cursor.addPoint((int)((double)RIGHT * 0.0), (int)((double)BOTTOM * 0.0));
    }

    public GraphicsUI(WhylineUI whylineUI, boolean isInput) {
        super(whylineUI, DynamicComponent.Sizing.SCROLL_OR_FIT_IF_SMALLER, DynamicComponent.Sizing.SCROLL_OR_FIT_IF_SMALLER);
        this.whylineUI = whylineUI;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setView(this.windows);
        this.menuChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MenuSelectionManager msm = (MenuSelectionManager)e.getSource();
                MenuElement[] path = msm.getSelectedPath();
                if (path.length > 0) {
                    MenuElement last = path[path.length - 1];
                    if (last instanceof JPopupMenu && path.length - 2 >= 0) {
                        last = path[path.length - 2];
                    }
                    Object subject = null;
                    if (last instanceof QuestionMenu.Menu) {
                        subject = ((QuestionMenu.Menu)last).getSubject();
                    } else if (last instanceof QuestionMenu.QuestionItem) {
                        subject = ((QuestionMenu.QuestionItem)last).getSubject();
                    }
                    if (subject instanceof ObjectState) {
                        GraphicsUI.this.setHighlight((ObjectState)subject);
                    } else if (subject instanceof GraphicalEventAppearance) {
                        GraphicsUI.this.setHighlight((GraphicalEventAppearance)subject);
                    } else if (subject instanceof RenderEvent) {
                        GraphicsUI.this.setHighlight((RenderEvent)subject);
                    }
                } else {
                    GraphicsUI.this.removeHighlight();
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.menuChangeListener);
    }

    public void updateScale() {
        this.selectedScale = this.whylineUI.isGraphicsFitToWindow() ? (int)((double)(100 * this.getViewportWidth()) / this.windows.getRightmostChildsRight()) : this.whylineUI.getGraphicsScale();
        double scale = this.getScale();
        this.windows.setPercentToScaleChildren(scale);
        this.windows.setPreferredSize(this.windows.getRightmostChildsRight() * scale, this.windows.getBottommostChildsBottom() * scale);
        this.updateSelectionState();
        this.repaint();
    }

    public void freeGlobalListeners() {
        MenuSelectionManager.defaultManager().removeChangeListener(this.menuChangeListener);
    }

    public void setHighlight(RenderEvent render) {
        this.setSelection(render);
    }

    public void setHighlight(GraphicalEventAppearance render) {
        this.setSelection(render);
    }

    public void setHighlight(ObjectState object) {
        this.setSelection(object);
    }

    public void removeHighlight() {
        this.setSelection(null);
    }

    private void setSelection(Named selection) {
        this.selection = selection;
        this.updateSelectionState();
    }

    private void updateSelectionState() {
        this.selectionShape = null;
        this.renderEventUnderMouse = null;
        if (this.selection instanceof ObjectState) {
            for (WindowView window : this.windowViews) {
                if (window.getWindowState().getWindowID() == ((ObjectState)this.selection).getObjectID()) {
                    this.selectionWindow = window;
                    this.selectionShape = new Rectangle(0, 0, (int)window.getLocalWidth(), (int)window.getLocalHeight());
                    continue;
                }
                Rectangle rect = window.getWindowState().getEntityBoundsBefore(((ObjectState)this.selection).getObjectID(), this.whylineUI.getInputEventID());
                if (rect == null) continue;
                this.selectionShape = rect;
                this.selectionWindow = window;
                break;
            }
        } else if (this.selection instanceof GraphicalEventAppearance || this.selection instanceof RenderEvent) {
            RenderEvent render = this.selection instanceof GraphicalEventAppearance ? ((GraphicalEventAppearance)this.selection).renderer : (RenderEvent)this.selection;
            this.selectionShape = render.getUnclippedShape();
            this.selectionWindow = this.getViewOfWindowID(render.getGraphicsState().getWindowState().getWindowID());
            this.renderEventUnderMouse = render;
            this.selectionIsText = render instanceof DrawCharsEvent || render instanceof DrawCharacterSequenceEvent || render instanceof DrawStringEvent;
        }
        this.latestInput = this.whylineUI.getTrace().getMouseHistory().getMostRecentBeforeTime(this.whylineUI.getOutputEventID());
        this.repaint();
    }

    public void addWindowState(WindowState window) {
        WindowView newWindowView = new WindowView(this, window);
        this.windowViews.add(newWindowView);
        newWindowView.setLocalLeft(this.windowViews.size() * 10, false);
        newWindowView.setLocalTop(this.windowViews.size() * 10, false);
        this.windows.addChild(newWindowView);
        newWindowView.updateSize();
        this.windows.handleContainerResize();
    }

    public WhylineUI getWhylineUI() {
        return this.whylineUI;
    }

    public int getVerticalScrollIncrement() {
        return 10;
    }

    public int getHorizontalScrollIncrement() {
        return 10;
    }

    private double getScale() {
        double chosenScale = (double)this.selectedScale / 100.0;
        return Math.max(Math.min(chosenScale, 4.0), 0.1);
    }

    private void drawWindowsAtEventID(int eventID) {
        for (WindowView window : this.windowViews) {
            window.setCurrentEventID(eventID);
        }
        this.updateSelectionState();
    }

    public WindowView getViewOfWindowID(long windowID) {
        for (WindowView window : this.windowViews) {
            if (window.getWindowState().getWindowID() != windowID) continue;
            return window;
        }
        return null;
    }

    public void inputTimeChanged(int time) {
        this.drawWindowsAtEventID(time);
    }

    public void outputTimeChanged(int time) {
    }
}

