/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class WhylineTabbedPane
extends JTabbedPane {
    public WhylineTabbedPane() {
        this.setUI(new WhylineTabbedPaneUI());
        this.setTabLayoutPolicy(1);
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Icon icon;
                int index = WhylineTabbedPane.this.indexAtLocation(e.getX(), e.getY());
                if (index == WhylineTabbedPane.this.getSelectedIndex() && (icon = WhylineTabbedPane.this.getIconAt(index)) != null) {
                    Rectangle bounds = WhylineTabbedPane.this.getBoundsAt(index);
                    int width = icon.getIconWidth();
                    Object ins = UIManager.get("TabbedPane.tabInsets");
                    if (ins instanceof InsetsUIResource) {
                        InsetsUIResource insets = (InsetsUIResource)ins;
                        if ((double)e.getX() > bounds.getX() + (double)insets.left && (double)e.getX() < bounds.getX() + (double)width + (double)insets.left) {
                            WhylineTabbedPane.this.selectedTabIconPressed(index);
                        }
                    }
                }
            }
        });
    }

    public Color getBackground() {
        return UI.getPanelLightColor();
    }

    public Color getForeground() {
        return UI.getPanelTextColor();
    }

    public void selectedTabIconPressed(int index) {
    }

    private class TabScrollButton
    extends WhylineButton
    implements UIResource {
        public TabScrollButton(int direction) {
            super("", null, "Scroll the tabs");
            char label = '-';
            switch (direction) {
                case 5: {
                    label = '\u2193';
                    break;
                }
                case 1: {
                    label = '\u2191';
                    break;
                }
                case 3: {
                    label = '\u2192';
                    break;
                }
                case 7: {
                    label = '\u2190';
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
                }
            }
            this.setText(Character.toString(label));
        }
    }

    private class WhylineTabbedPaneUI
    extends MetalTabbedPaneUI {
        private WhylineTabbedPaneUI() {
        }

        protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        }

        protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        }

        protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        }

        protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            g = g.create();
            g.clipRect(x, y, w + 2, h);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (isSelected) {
                g.setColor(UI.getPanelDarkColor());
                g.fillRoundRect(x + 1, y, w - 2, h + UI.getBorderPadding(), UI.getRoundedness(), UI.getRoundedness());
                g.setColor(UI.getControlBorderColor());
                g.drawRoundRect(x + 1, y, w - 2, h + UI.getBorderPadding(), UI.getRoundedness(), UI.getRoundedness());
            }
            g.setColor(UI.getControlBorderColor());
            g.drawLine(x, y + h - 1, x + w, y + h - 1);
        }

        protected JButton createScrollButton(int direction) {
            return new TabScrollButton(direction);
        }
    }
}

