/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import edu.cmu.hcii.whyline.trace.nodes.ClassNode;
import edu.cmu.hcii.whyline.trace.nodes.DynamicNode;
import edu.cmu.hcii.whyline.trace.nodes.Node;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.HeadlinedPanel;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeadlinedTreePanel<T>
extends HeadlinedPanel {
    private final WhylineScrollPane scroller;
    private final JTree tree;
    private final TreeSelectionListener selectionListener = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent e) {
            Node<?> selection = HeadlinedTreePanel.this.getSelectedNode();
            if (selection != null) {
                if (selection.update()) {
                    HeadlinedTreePanel.this.updateTree();
                }
                HeadlinedTreePanel.this.handleSelection();
            }
        }
    };
    private final TreeExpansionListener expansionListener = new TreeExpansionListener(){

        public void treeExpanded(TreeExpansionEvent e) {
            HeadlinedTreePanel.this.handleExpansion();
        }

        public void treeCollapsed(TreeExpansionEvent e) {
        }
    };
    private final Node<T> root = new Node<T>(){

        public int compareTo(Node<T> o) {
            return 0;
        }

        @Override
        public String toString() {
            return "root";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected void determineChildren() {
        }

        @Override
        protected boolean performUpdate() {
            return false;
        }
    };
    private final TreeModel model = new TreeModel(){

        public Object getChild(Object parent, int index) {
            return ((Node)parent).get(index);
        }

        public int getChildCount(Object parent) {
            return ((Node)parent).getNumberOfChildren();
        }

        public Object getRoot() {
            return HeadlinedTreePanel.this.root;
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((Node)parent).indexOf(child);
        }

        public boolean isLeaf(Object node) {
            return ((Node)node).isLeaf();
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public void addTreeModelListener(TreeModelListener l) {
            HeadlinedTreePanel.this.listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            HeadlinedTreePanel.this.listeners.remove(l);
        }
    };
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public HeadlinedTreePanel(String header, WhylineUI whylineUI) {
        super(header, whylineUI);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                c.setForeground(sel ? UI.getHighlightTextColor() : UI.getControlTextColor());
                String text = ((JLabel)c).getText();
                ((JLabel)c).setText("");
                if (value instanceof ClassNode) {
                    c.setFont(UI.getMediumFont().deriveFont(1));
                } else {
                    c.setFont(UI.getMediumFont());
                }
                ((JLabel)c).setText(text);
                return c;
            }
        };
        renderer.setBackground(UI.getControlBackColor());
        renderer.setForeground(UI.getControlTextColor());
        renderer.setBorder(null);
        renderer.setFont(UI.getMediumFont());
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.setScrollsOnExpand(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setFocusable(false);
        this.tree.setOpaque(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(this.selectionListener);
        this.tree.addTreeExpansionListener(this.expansionListener);
        this.scroller = new WhylineScrollPane(this.tree);
        this.scroller.setBorder(new WhylineControlBorder());
        this.setContent(this.scroller);
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), UI.getDefaultInfoPaneHeight(whylineUI)));
    }

    public final Node<T> getRoot() {
        return this.root;
    }

    protected final void updateTree() {
        boolean selectionIsExpanded;
        Node<?> selectedNode = this.getSelectedNode();
        TreePath selectionPath = this.getSelectionPath();
        boolean bl = selectionIsExpanded = selectionPath == null ? false : this.tree.isExpanded(selectionPath);
        if (selectedNode != null) {
            selectedNode.update();
        }
        this.tree.removeTreeSelectionListener(this.selectionListener);
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
        }
        this.tree.addTreeSelectionListener(this.selectionListener);
        this.tree.clearSelection();
        if (selectionPath != null) {
            this.show(selectionPath, selectionIsExpanded);
        }
    }

    public final void clearSelection() {
        this.tree.clearSelection();
        this.tree.scrollRowToVisible(0);
    }

    public final Node<?> getSelectedNode() {
        if (this.getSelectionPath() == null) {
            return null;
        }
        Object selection = this.getSelectionPath().getLastPathComponent();
        return selection instanceof Node ? (Node)selection : null;
    }

    public final DynamicNode<?> getSelectedDynamicNode() {
        Node<?> node = this.getSelectedNode();
        return node == null ? null : (node instanceof DynamicNode ? (DynamicNode)node : null);
    }

    public final void show(TreePath path, boolean expandLast) {
        this.tree.removeTreeSelectionListener(this.selectionListener);
        this.tree.expandPath(expandLast ? path : path.getParentPath());
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
        this.tree.repaint();
        this.tree.addTreeSelectionListener(this.selectionListener);
    }

    protected abstract void handleSelection();

    protected abstract void handleExpansion();

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }
}

