/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.arrows.ArrowView;
import edu.cmu.hcii.whyline.ui.qa.AnswerUI;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.qa.VisualizationUI;
import edu.cmu.hcii.whyline.ui.source.FilesView;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnexecutedArrowView
extends ArrowView {
    private final UnexecutedInstruction unexecuted;
    private final FilesView.ArrowBox arrows;
    private final FilesView files;
    protected int left;
    protected int baseline;
    private final GlyphVector glyphs;
    protected final Rectangle2D glyphBounds;
    protected final int descent;
    protected TokenRange toRange;
    protected TokenRange fromRange;

    public UnexecutedArrowView(FilesView.ArrowBox arrows, UnexecutedInstruction cause, UnexecutedInstruction effect, int number) {
        super(arrows.getFilesView().getWhylineUI(), number);
        this.files = arrows.getFilesView();
        this.unexecuted = cause;
        cause.explain();
        Instruction inst = cause.getInstruction();
        String event = inst instanceof Branch ? "the conditional on" : (inst instanceof Invoke ? "the call to " + ((Invoke)inst).getJavaMethodName() + "() on" : "");
        String label = "why didn't " + event + " " + inst.getLineNumber() + " execute?";
        this.arrows = arrows;
        Graphics2D g = (Graphics2D)this.whylineUI.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.glyphs = UI.getSmallFont().createGlyphVector(g.getFontRenderContext(), label);
        this.glyphBounds = this.glyphs.getLogicalBounds();
        this.descent = g.getFontMetrics(UI.getSmallFont()).getDescent();
        this.fromRange = cause.getInstruction().getFile().getTokenRangeFor(cause.getInstruction());
        this.toRange = effect.getInstruction().getFile().getTokenRangeFor(effect.getInstruction());
    }

    @Override
    public final List<TokenRange> getViableTargetTokenRanges() {
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>(2);
        ranges.add(this.toRange);
        ranges.add(this.fromRange);
        return ranges;
    }

    @Override
    public boolean containsLocalPoint(int x, int y) {
        return (double)x >= this.getLocalLeft() && (double)x < this.getLocalRight() && (double)y >= this.getLocalTop() && (double)y <= this.getLocalBottom();
    }

    @Override
    protected void clicked() {
        VisualizationUI viz;
        AnswerUI answerUI = this.whylineUI.getQuestionsUI().getAnswerUIVisible();
        if (answerUI != null && (viz = answerUI.getSituationSelected().getVisualizationUI()) != null) {
            viz.setSelection(viz.getVisualization().getUnexecutedInstructionView(this.unexecuted), true, "arrow");
            this.whylineUI.selectUnexecutedInstruction(this.unexecuted, true, "arrow");
        }
    }

    @Override
    public final void layout() {
        Visualization viz;
        Visualization visualization = viz = this.whylineUI.getVisualizationUIVisible() == null ? null : this.whylineUI.getVisualizationUIVisible().getVisualization();
        if (viz == null) {
            return;
        }
        int lineHeight = (int)(this.glyphBounds.getHeight() * 1.25);
        this.baseline = (this.dependencyNumber + 2) * lineHeight;
        this.left = this.arrows.getPadding();
        this.setLocalLeft(this.left, false);
        this.setLocalTop((double)(this.baseline + this.descent) - this.glyphBounds.getHeight(), false);
        this.setLocalWidth(this.glyphBounds.getWidth(), false);
        this.setLocalHeight(lineHeight, false);
    }

    @Override
    public void paintAboveChildren(Graphics2D g) {
        boolean selected = this.whylineUI.getArrowOver() == this.dependencyNumber;
        g.setColor(UI.getFileColor());
        g.drawGlyphVector(this.glyphs, this.left, this.baseline);
        if (selected) {
            g = (Graphics2D)g.create();
            g.translate(-this.getGlobalLeft() + this.getLocalLeft(), -this.getGlobalTop() + this.getLocalTop());
            int padding = 1;
            int labelLeft = (int)this.getGlobalLeft() - padding;
            int labelRight = labelLeft + (int)this.glyphBounds.getWidth() + padding * 2;
            int labelTop = (int)this.getGlobalTop() - padding;
            int labelBottom = labelTop + (int)this.getGlobalHeight() + padding * 2;
            g.setColor(UI.ERROR_COLOR);
            Area toArea = this.files.outline(g, this.toRange);
            Area fromArea = this.files.outline(g, this.fromRange);
            if (toArea != null && fromArea != null) {
                Rectangle2D toBounds = toArea.getBounds2D();
                Rectangle2D fromBounds = fromArea.getBounds2D();
                Line2D line = Util.getLineBetweenRectangleEdges(fromBounds.getMinX(), fromBounds.getMaxX(), fromBounds.getMinY(), fromBounds.getMaxY(), toBounds.getMinX(), toBounds.getMaxX(), toBounds.getMinY(), toBounds.getMaxY());
                int xOff = 0;
                int yOff = 0;
                Util.drawQuadraticCurveArrow(g, (int)line.getX1(), (int)line.getY1(), (int)line.getX2(), (int)line.getY2(), xOff, yOff, true, UI.SELECTED_STROKE);
            }
        }
    }
}

