/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.WhyDidEventOccur;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.DynamicNode;
import edu.cmu.hcii.whyline.trace.nodes.FrameState;
import edu.cmu.hcii.whyline.trace.nodes.LocalState;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;
import edu.cmu.hcii.whyline.trace.nodes.ThreadState;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.HeadlinedTreePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadsUI
extends HeadlinedTreePanel<ThreadState> {
    private ThreadState[] threads = null;
    private int currentEventID;
    private final Action watchAction = new AbstractAction("watch \u2191"){

        public void actionPerformed(ActionEvent e) {
            ThreadsUI.this.whylineUI.getObjectsUI().addObject(ThreadsUI.this.getSelectedObjectID());
            this.setEnabled(false);
        }
    };
    private final Action explainAction = new AbstractAction("explain"){

        public void actionPerformed(ActionEvent e) {
            int eventID = ThreadsUI.this.getSelectedDynamicNode().getAssociatedEventID();
            WhyDidEventOccur q = new WhyDidEventOccur((Asker)ThreadsUI.this.whylineUI, eventID, ThreadsUI.this.getTrace().getDescription(eventID));
            ThreadsUI.this.whylineUI.answer(q);
        }
    };
    private final Action showCallAction = new AbstractAction("show call"){

        public void actionPerformed(ActionEvent e) {
            int eventID = ((FrameState)ThreadsUI.this.getSelectedDynamicNode()).getInvocationID();
            Explanation call = ThreadsUI.this.whylineUI.getVisualizationUIVisible().getAnswer().getExplanationFor(eventID);
            ThreadsUI.this.whylineUI.selectExplanation(call, true, "threads");
        }
    };

    public ThreadsUI(WhylineUI whylineUI) {
        super("threads", whylineUI);
        this.watchAction.setEnabled(false);
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), 0));
        this.setPreferredSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), UI.getDefaultInfoPaneHeight(whylineUI)));
        this.addTool(new WhylineButton(this.watchAction, "watch the selected object"));
        if (whylineUI.getMode() == WhylineUI.Mode.WHYLINE) {
            this.addTool(new WhylineButton(this.explainAction, "explain why the selected field has its current value"));
            this.addTool(new WhylineButton(this.showCallAction, "show the selected call in the visualization"));
        }
    }

    @Override
    protected void handleSelection() {
        long objectID = this.getSelectedObjectID();
        this.watchAction.setEnabled(objectID > 0L && !this.whylineUI.getObjectsUI().isWatching(objectID));
        if (this.whylineUI.isWhyline()) {
            DynamicNode<?> node = this.getSelectedDynamicNode();
            this.explainAction.setEnabled(node != null && node.getAssociatedEventID() > 0);
            if (objectID > 0L) {
                this.whylineUI.getGraphicsUI().setHighlight(this.whylineUI.getTrace().getObjectNode(objectID));
            }
            if (this.whylineUI.getVisualizationUIVisible() != null) {
                this.showCallAction.setEnabled(false);
                DynamicNode<?> frame = this.getSelectedDynamicNode();
                if (node instanceof FrameState) {
                    int invocationID = ((FrameState)frame).getInvocationID();
                    this.showCallAction.setEnabled(true);
                }
            }
            this.repaint();
        }
    }

    @Override
    protected void handleExpansion() {
        if (this.getSelectedDynamicNode() instanceof ReferenceState) {
            ReferenceState ref = (ReferenceState)this.getSelectedDynamicNode();
            for (ReferenceState node : ref.getChildren()) {
                node.propagateCurrentEventID(ref.getCurrentEventID());
            }
        }
    }

    public long getSelectedObjectID() {
        if (this.getSelectionPath() == null) {
            return 0L;
        }
        Object selection = this.getSelectionPath().getLastPathComponent();
        return selection instanceof ReferenceState ? ((ReferenceState)selection).getObjectIDForChildren() : 0L;
    }

    private Trace getTrace() {
        return this.whylineUI.getTrace();
    }

    public void showEventID(int eventID) {
        if (this.currentEventID == eventID) {
            return;
        }
        if (!this.whylineUI.isDynamicInfoShowing()) {
            return;
        }
        this.currentEventID = eventID;
        this.getRoot().resetChildren();
        if (this.threads == null && this.whylineUI.getTrace().isDoneLoading()) {
            this.threads = new ThreadState[this.whylineUI.getTrace().getNumberOfThreads()];
            int id = 0;
            while (id < this.threads.length) {
                this.threads[id] = new ThreadState(this.whylineUI.getTrace(), id);
                ++id;
            }
        }
        ThreadState[] threadStateArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadState thread = threadStateArray[n2];
            if (this.getTrace().getThreadFirstEventID(thread.getThreadID()) <= this.currentEventID && this.getTrace().getThreadLastEventID(thread.getThreadID()) >= this.currentEventID) {
                this.getRoot().addChild(thread);
                thread.showEventID(this.currentEventID);
            }
            ++n2;
        }
        this.updateTree();
        if (this.currentEventID >= 0) {
            Object[] objectArray;
            LocalState currentLocal;
            ThreadState currentThread = this.threads[this.whylineUI.getTrace().getThreadID(this.currentEventID)];
            FrameState currentFrame = currentThread.getFrameFor(this.currentEventID);
            LocalState localState = currentLocal = currentFrame == null ? null : currentFrame.getLocalFor(this.currentEventID);
            if (currentLocal != null) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = this.getRoot();
                objectArray2[1] = currentThread;
                objectArray2[2] = currentFrame;
                objectArray = objectArray2;
                objectArray2[3] = currentLocal;
            } else if (currentFrame != null) {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = this.getRoot();
                objectArray3[1] = currentThread;
                objectArray = objectArray3;
                objectArray3[2] = currentFrame;
            } else {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = this.getRoot();
                objectArray = objectArray4;
                objectArray4[1] = currentThread;
            }
            TreePath threadPath = new TreePath(objectArray);
            this.show(threadPath, true);
        }
    }
}

