/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.tracing.AgentOptions;
import edu.cmu.hcii.whyline.util.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionConfiguration {
    private static final String CONFIG_TAG = "config";
    private static final String NAME_TAG = "name";
    private static final String PROJECT_TAG = "location";
    private static final String CLASSES_TAG = "classes";
    private static final String SOURCE_TAG = "source";
    private static final String MAIN_TAG = "main";
    private static final String ARGS_TAG = "arguments";
    private static final String STARTMEM_TAG = "startmemory";
    private static final String MAXMEM_TAG = "maxmemory";
    private static final String CLASSPATH_TAG = "classpath";
    private static final String SKIP_TAG = "classestoskip";
    private String name = "";
    private String projectPath = "";
    private String classpaths = "";
    private String sourcepaths = "";
    private String arguments = "";
    private String mainClass = "";
    private String locationLastCheckedForMains;
    private String startMemory = "64";
    private String maxMemory = "128";
    private String classesToSkip = "";
    private SortedSet<String> classfilesWithMain = new TreeSet<String>();

    public ExecutionConfiguration(String location, String main, String arguments, String start, String max, String classpath) {
        this.name = new File(location).getName();
        this.projectPath = location;
        this.arguments = arguments;
        this.startMemory = start;
        this.maxMemory = max;
        this.classpaths = classpath;
        this.mainClass = main;
    }

    public ExecutionConfiguration(Node config) {
        this.name = "unnamed";
        NodeList children = config.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node child = children.item(j);
            if (child.getNodeType() == 1) {
                String tag = child.getNodeName();
                NodeList tagChildren = child.getChildNodes();
                if (tagChildren.getLength() == 1 && tagChildren.item(0).getNodeType() == 3) {
                    String value = tagChildren.item(0).getNodeValue();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if (tag.startsWith(PROJECT_TAG)) {
                        this.projectPath = value;
                    } else if (tag.equals(NAME_TAG)) {
                        this.name = value;
                    } else if (tag.equals(SOURCE_TAG)) {
                        this.sourcepaths = value;
                    } else if (tag.equals(MAIN_TAG)) {
                        this.mainClass = value;
                    } else if (tag.equals(ARGS_TAG)) {
                        this.arguments = value;
                    } else if (tag.equals(STARTMEM_TAG)) {
                        this.startMemory = value;
                    } else if (tag.equals(MAXMEM_TAG)) {
                        this.maxMemory = value;
                    } else if (tag.equals(CLASSPATH_TAG)) {
                        this.classpaths = value;
                    } else if (tag.equals(SKIP_TAG)) {
                        this.classesToSkip = value.replace(",", "\n");
                    }
                }
            }
            ++j;
        }
    }

    private void tag(FileWriter writer, String tag, String value) throws IOException {
        writer.write("<");
        writer.write(tag);
        writer.write(">");
        writer.write("\"" + value + "\"");
        writer.write("</");
        writer.write(tag);
        writer.write(">");
        writer.write("\n");
    }

    public void write(FileWriter writer) throws IOException {
        writer.write("<config>\n");
        this.tag(writer, NAME_TAG, this.name);
        this.tag(writer, PROJECT_TAG, this.projectPath);
        this.tag(writer, CLASSPATH_TAG, this.classpaths);
        this.tag(writer, SOURCE_TAG, this.sourcepaths);
        this.tag(writer, MAIN_TAG, this.mainClass);
        this.tag(writer, ARGS_TAG, this.arguments);
        this.tag(writer, STARTMEM_TAG, this.startMemory);
        this.tag(writer, MAXMEM_TAG, this.maxMemory);
        this.tag(writer, SKIP_TAG, this.classesToSkip.replace("\n", ","));
        writer.write("</config>\n");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectPath(String location) {
        this.projectPath = location;
    }

    private static void findClassAndJARFiles(File directory, List<File> classfiles) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ExecutionConfiguration.findClassAndJARFiles(file, classfiles);
            } else if (file.getName().endsWith(".class")) {
                classfiles.add(file);
            } else if (file.getName().endsWith(".jar")) {
                classfiles.add(file);
            }
            ++n2;
        }
    }

    public void determineClassesWithMain() {
        String[] paths;
        String[] stringArray;
        if (this.projectPath.equals(this.locationLastCheckedForMains)) {
            return;
        }
        this.locationLastCheckedForMains = this.projectPath;
        this.classfilesWithMain.clear();
        File project = new File(this.projectPath);
        if (!project.exists()) {
            return;
        }
        if (this.classpaths.equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.projectPath;
        } else {
            stringArray = this.classpaths.split(File.pathSeparator);
        }
        String[] stringArray3 = paths = stringArray;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray3[n2];
            File classes = new File(path);
            if (!classes.isAbsolute()) {
                classes = new File(this.projectPath, path);
            }
            if (classes.isDirectory()) {
                Vector<File> files = new Vector<File>();
                ExecutionConfiguration.findClassAndJARFiles(classes, files);
                for (File file : files) {
                    if (file.getName().endsWith(".class")) {
                        try {
                            String name = Classfile.hasMain(Util.getReaderFor(file));
                            if (name == null) continue;
                            this.classfilesWithMain.add(name);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (!file.getName().endsWith(".jar")) continue;
                    this.processJAR(file);
                }
            } else if (classes.getName().endsWith(".jar")) {
                this.processJAR(classes);
            }
            ++n2;
        }
    }

    private void processJAR(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class") || (name = Classfile.hasMain(new DataInputStream(jar.getInputStream(entry)))) == null) continue;
                this.classfilesWithMain.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SortedSet<String> getClassfilesWithMain() {
        return this.classfilesWithMain;
    }

    public String getSourcePaths() {
        return this.sourcepaths;
    }

    public void setSourcePaths(String pathToSource) {
        this.sourcepaths = pathToSource;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    private String convertPathToClassesToPathList() {
        String pathList = "";
        File classes = new File(this.projectPath);
        if (classes.isDirectory()) {
            pathList = classes.getAbsolutePath();
            ArrayList<File> files = new ArrayList<File>();
            ExecutionConfiguration.findClassAndJARFiles(classes, files);
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                pathList = String.valueOf(pathList) + File.pathSeparator + file.getAbsolutePath();
            }
        } else if (classes.getName().endsWith(".jar")) {
            pathList = classes.getAbsolutePath();
        }
        return pathList;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String args) {
        this.arguments = args;
    }

    public String getStartMemory() {
        return this.startMemory;
    }

    public void setStartMemory(String startMemory) {
        this.startMemory = startMemory;
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    public String getClassPaths() {
        return this.classpaths;
    }

    public void setClassPaths(String classpathAdditions) {
        this.classpaths = classpathAdditions;
    }

    public String getAbsoluteClasspathAdditions() {
        String[] paths = this.classpaths.split(File.pathSeparator);
        String result = "";
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            result = String.valueOf(result) + this.projectPath + (this.projectPath.endsWith(File.separator) ? "" : Character.valueOf(File.separatorChar)) + path + File.pathSeparatorChar;
            ++n2;
        }
        return result;
    }

    public String getClassesToSkip() {
        return this.classesToSkip;
    }

    public void setClassesToSkip(String classesToSkip) {
        this.classesToSkip = classesToSkip;
    }

    public String[] getExecutionCommand(File pathToWhylineJAR, AgentOptions options, boolean quoteClasspath) {
        String programArguments = this.getArguments().trim();
        String[] programArgs = programArguments.equals("") ? new String[]{} : programArguments.split(" ");
        int numberOfArguments = 9;
        String[] args = new String[numberOfArguments + programArgs.length];
        args[0] = "java";
        args[1] = "-Dswing.defaultlaf=javax.swing.plaf.metal.MetalLookAndFeel";
        args[2] = "-cp";
        args[3] = String.valueOf(quoteClasspath ? "\"" : "") + pathToWhylineJAR.getAbsolutePath() + File.pathSeparatorChar + this.convertPathToClassesToPathList() + (this.getClassPaths().equals("") ? "" : String.valueOf(File.pathSeparatorChar) + this.getAbsoluteClasspathAdditions()) + (quoteClasspath ? "\"" : "");
        args[4] = "-Xbootclasspath/p:" + pathToWhylineJAR.getPath();
        args[5] = "-Xms" + this.getStartMemory() + "m";
        args[6] = "-Xmx" + this.getMaxMemory() + "m";
        args[7] = "-javaagent:" + pathToWhylineJAR.getPath() + "=" + (options == null ? "" : options.getOptionsAsValidCommandLineArgument());
        args[8] = this.getMainClass();
        int i = numberOfArguments;
        while (i < args.length) {
            args[i] = programArgs[i - numberOfArguments];
            ++i;
        }
        return args;
    }

    public boolean isValid() {
        return ExecutionConfiguration.isValidProjectLocation(this.projectPath) == null && ExecutionConfiguration.isValidMemory(this.getStartMemory()) == null && ExecutionConfiguration.isValidMemory(this.getMaxMemory()) == null && ExecutionConfiguration.isValidPathList(this.projectPath, this.classpaths) == null && ExecutionConfiguration.isValidPathList(this.projectPath, this.sourcepaths) == null && ExecutionConfiguration.isValidClassWithMain(this.projectPath, this.classpaths, this.mainClass) == null;
    }

    public String getJavaCommand(AgentOptions options, boolean quoteClasspath) {
        String[] args = this.getExecutionCommand(Whyline.WHYLINE_JAR_PATH, options, quoteClasspath);
        String command = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            command = String.valueOf(command) + s + " ";
            ++n2;
        }
        return command;
    }

    public String toString() {
        return this.name;
    }

    public static String isValidMemory(String mem) {
        try {
            int mb = Integer.parseInt(mem);
            if (mb < 1) {
                return "Must be greater than or equal to 1";
            }
            return null;
        }
        catch (NumberFormatException e) {
            return "Must be an integer";
        }
    }

    public static String isValidProjectLocation(String text) {
        File folder = new File(text);
        if (!folder.exists()) {
            return "Couldn't find folder...";
        }
        if (!folder.isDirectory()) {
            return "The project path must be a folder, not a file";
        }
        return null;
    }

    public static String isValidPathList(String project, String pathsString) {
        String[] paths;
        String[] stringArray = paths = pathsString.split(File.pathSeparator);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (!file.isAbsolute()) {
                file = new File(project, path);
            }
            if (!file.exists()) {
                return "Couldn't find file \"" + path + "\"";
            }
            if (!file.isDirectory() && !file.getName().endsWith(".jar")) {
                return "File must be a directory or .jar file";
            }
            ++n2;
        }
        return null;
    }

    public static String isValidClassWithMain(String project, String classPaths, String classname) {
        if (classname == null || classname.equals("")) {
            return "Must specify a class name to execute";
        }
        classname = String.valueOf(classname.replace(".", File.separator)) + ".class";
        String[] paths = classPaths.split(File.pathSeparator);
        File classfile = null;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (!file.isAbsolute()) {
                file = new File(project, path);
            }
            if ((classfile = new File(file, classname)).exists()) break;
            classfile = null;
            ++n2;
        }
        if (classfile == null) {
            return null;
        }
        return null;
    }
}

