/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.tracing.AgentOptions;
import edu.cmu.hcii.whyline.tracing.ClassIDs;
import edu.cmu.hcii.whyline.tracing.ClassInstrumenter;
import edu.cmu.hcii.whyline.tracing.Tracer;
import edu.cmu.hcii.whyline.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Agent {
    private static File sourcefileFile;
    static DataOutputStream classes;
    private static String projectPath;
    public static ClassIDs classIDs;

    static {
        projectPath = null;
        try {
            File classIDsFile = new File(Whyline.getWorkingTraceFolder(), Whyline.CLASSIDS_PATH);
            if (!Whyline.getWorkingClassIDsFile().exists()) {
                Whyline.getWorkingClassIDsFile().createNewFile();
            }
            Util.copyFile(Whyline.getWorkingClassIDsFile(), classIDsFile);
            classIDs = new ClassIDs(classIDsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static void fail(String message) {
        Whyline.debugBreak();
        Whyline.debug(message);
        Whyline.debugBreak();
        System.exit(711);
    }

    public static void premain(String optionsString, Instrumentation instrumentation) {
        try {
            Util.deleteFolder(Whyline.getWorkingTraceFolder());
            new File(Whyline.getWorkingTraceFolder(), "static").mkdirs();
            new File(Whyline.getWorkingTraceFolder(), "dynamic").mkdir();
            new File(Whyline.getWorkingTraceFolder(), Whyline.HISTORY_PATH).mkdir();
            classes = Util.getWriterFor(Whyline.getWorkingClassnamesFile());
            Agent.processAgentOptions(optionsString);
            EventKind.class.getEnumConstants();
            instrumentation.addTransformer(new ClassInstrumenter());
            Class[] classArray = instrumentation.getAllLoadedClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                QualifiedClassName name = QualifiedClassName.get(c.getName());
                if (name != null) {
                    classIDs.includeClassName(name);
                    Class superclass = c.getSuperclass();
                    if (superclass != null) {
                        classIDs.markSuperclass(name, QualifiedClassName.get(superclass.getName()));
                    }
                    if (c.getClassLoader() == null && !name.isArray() && !name.isPrimitive()) {
                        Agent.addClassToTrace(name, null, 0L, ClassInstrumenter.bootClassPath);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Agent.fail(e.toString());
        }
        Whyline.debug("Invoking main()...");
    }

    private static void processAgentOptions(String optionsString) throws IOException {
        AgentOptions options = new AgentOptions(optionsString);
        projectPath = (String)options.getOption(AgentOptions.Option.PROJECT);
        String classPaths = (String)options.getOption(AgentOptions.Option.CLASSES);
        Whyline.debug("Writing user's classes...");
        Agent.processUserClasses(classPaths);
        Whyline.debug("Writing user's source...");
        String sourcePaths = (String)options.getOption(AgentOptions.Option.SOURCE);
        Agent.cacheUserSourceFiles(sourcePaths);
        if (options.declaresOption(AgentOptions.Option.PRINT_INSTRUMENTATION_SUMMARY)) {
            ClassInstrumenter.DEBUG_INSTRUMENTATION = (Boolean)options.getOption(AgentOptions.Option.PRINT_INSTRUMENTATION_SUMMARY);
        }
        if (options.declaresOption(AgentOptions.Option.PRINT_INSTRUMENTATION_SUMMARY)) {
            Tracer.DEBUG_CLASSES_INSTRUMENTED = (Boolean)options.getOption(AgentOptions.Option.PRINT_INSTRUMENTATION_SUMMARY);
        }
        if (options.declaresOption(AgentOptions.Option.PRINT_METHODS_BEFORE_AND_AFTER)) {
            ClassInstrumenter.DEBUG_BEFORE_AND_AFTER = (Boolean)options.getOption(AgentOptions.Option.PRINT_METHODS_BEFORE_AND_AFTER);
        }
        String prefixesToSkip = (String)options.getOption(AgentOptions.Option.SKIP);
        String[] stringArray = prefixesToSkip.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            ClassInstrumenter.addPrefixToSkip(prefix.replace(".", "/"));
            ++n2;
        }
    }

    private static void processUserClasses(String classPaths) throws IOException {
        String[] paths;
        String[] stringArray;
        if (classPaths.equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = projectPath;
        } else {
            stringArray = classPaths.split(File.pathSeparator);
        }
        String[] stringArray3 = paths = stringArray;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray3[n2];
            File classes = new File(path);
            if (!classes.isAbsolute()) {
                classes = new File(projectPath, path);
            }
            if (!classes.exists()) {
                Agent.fail("Couldn't find a file or directory with the name \"" + path + "\"");
            } else if (classes.isDirectory()) {
                Agent.recursivelyProcessUserClassesInFolder(classes, "");
            } else if (!classes.getName().endsWith(".jar")) {
                long lastModified = classes.lastModified();
                JarFile jar = new JarFile(classes);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().endsWith(".class")) continue;
                    QualifiedClassName qualifiedClassName = QualifiedClassName.get(entry.getName().substring(0, entry.getName().lastIndexOf(".")));
                    Agent.cacheUserClassfile(qualifiedClassName, jar.getInputStream(entry), entry.getSize(), lastModified, classes.getAbsolutePath());
                }
            }
            ++n2;
        }
    }

    private static void recursivelyProcessUserClassesInFolder(File directory, String qualifier) throws IOException {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Agent.recursivelyProcessUserClassesInFolder(file, String.valueOf(qualifier) + file.getName() + "/");
            } else if (file.getName().endsWith(".class")) {
                QualifiedClassName qualifiedClassName = QualifiedClassName.get(String.valueOf(qualifier) + file.getName().substring(0, file.getName().lastIndexOf(".")));
                Agent.cacheUserClassfile(qualifiedClassName, new FileInputStream(file), file.length(), file.lastModified(), file.getAbsolutePath());
            } else if (file.getName().endsWith(".jar")) {
                long lastModified = file.lastModified();
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().endsWith(".class")) continue;
                    QualifiedClassName qualifiedClassName = QualifiedClassName.get(entry.getName().substring(0, entry.getName().lastIndexOf(".")));
                    Agent.cacheUserClassfile(qualifiedClassName, jar.getInputStream(entry), entry.getSize(), file.lastModified(), file.getAbsolutePath());
                }
            }
            ++n2;
        }
    }

    private static void cacheUserClassfile(QualifiedClassName classname, InputStream stream, long numberOfBytes, long modificationDate, String classpaths) {
        classIDs.markClassnameModificationDate(classname, modificationDate);
        byte[] bytes = new byte[(int)numberOfBytes];
        try {
            BufferedInputStream reader = new BufferedInputStream(stream);
            reader.read(bytes);
            Agent.addClassToTrace(classname, classpaths == null ? new Classfile(bytes).toByteArray() : null, modificationDate, classpaths);
        }
        catch (IOException e) {
            e.printStackTrace();
            Agent.fail("There was writing " + classname);
        }
        catch (JavaSpecificationViolation e) {
            e.printStackTrace();
            Agent.fail(e.getMessage());
        }
        catch (AnalysisException e) {
            e.printStackTrace();
            Agent.fail(e.getMessage());
        }
    }

    private static void cacheUserSourceFiles(String sourcePaths) throws IOException {
        String[] stringArray;
        if (sourcePaths.equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = projectPath;
        } else {
            stringArray = sourcePaths.split(File.pathSeparator);
        }
        String[] paths = stringArray;
        Whyline.getWorkingSourceFolder().mkdir();
        String[] stringArray3 = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray3[n2];
            File source = new File(path);
            if (!source.isAbsolute()) {
                source = new File(projectPath, path);
            }
            if (!source.exists()) {
                Agent.fail("I couldn't find a file or directory with the name \"" + path + "\"");
            } else if (source.isDirectory()) {
                Agent.findJavaSourceFilesInApplicationPath(source, "");
            } else if (source.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(source);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().endsWith(".java")) continue;
                    DataInputStream stream = new DataInputStream(jar.getInputStream(entry));
                    byte[] bytes = new byte[(int)entry.getSize()];
                    stream.readFully(bytes);
                    FileOutputStream out = new FileOutputStream(new File(entry.getName().replace('/', File.separatorChar)));
                    out.write(bytes);
                }
            }
            ++n2;
        }
    }

    private static void findJavaSourceFilesInApplicationPath(File directory, String qualifier) throws IOException {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Agent.findJavaSourceFilesInApplicationPath(file, String.valueOf(qualifier) + file.getName() + "/");
            } else if (file.getName().endsWith(".java")) {
                File newFolder = new File(Whyline.getWorkingSourceFolder(), qualifier.replace('/', File.separatorChar));
                newFolder.mkdirs();
                Util.copyFile(file, new File(newFolder, file.getName()));
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClassToTrace(QualifiedClassName name, byte[] bytes, long modificationDate, String paths) {
        if (name.getText().startsWith("edu/cmu/hcii/whyline")) {
            return;
        }
        DataOutputStream dataOutputStream = classes;
        synchronized (dataOutputStream) {
            try {
                String classname = name.getText();
                File classfile = null;
                if (paths == null) {
                    String filename = String.valueOf(classname.replace('/', File.separatorChar)) + ".class";
                    classfile = new File(Whyline.getUninstrumentedClassCacheFolder(), filename);
                    paths = classfile.getAbsolutePath();
                }
                classes.writeUTF(classname);
                classes.writeUTF(paths);
                ++Tracer.numberOfClassfiles;
                if (bytes != null) {
                    classfile.delete();
                    classfile.getParentFile().mkdirs();
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(classfile, false));
                    ((OutputStream)out).write(bytes);
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

