/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node<T> {
    private boolean childrenDetermined = false;
    private final SortedSet<T> children = new TreeSet<T>();
    protected boolean isUpdated = false;

    public T get(int index) {
        int i = 0;
        for (Object child : this.getChildren()) {
            if (i == index) {
                return (T)child;
            }
            ++i;
        }
        return null;
    }

    public int indexOf(Object c) {
        int i = 0;
        for (Object child : this.getChildren()) {
            if (child == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean hasDeterminedChildren() {
        return this.childrenDetermined;
    }

    public SortedSet<T> getChildren() {
        if (!this.childrenDetermined) {
            this.determineChildren();
            this.childrenDetermined = true;
        }
        return this.children;
    }

    public void resetChildren() {
        this.children.clear();
        this.determineChildren();
    }

    public int getNumberOfChildren() {
        return this.getChildren().size();
    }

    protected abstract void determineChildren();

    public void addChild(T child) {
        this.children.add(child);
    }

    public abstract boolean isLeaf();

    public abstract String toString();

    public void removeChild(T child) {
        this.children.remove(child);
    }

    public final boolean update() {
        if (!this.isUpdated) {
            boolean changed = this.performUpdate();
            this.isUpdated = true;
            return changed;
        }
        return false;
    }

    protected abstract boolean performUpdate();
}

