/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.CauseAnswer;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraceValue
extends Value {
    private final int eventID;
    private final Instruction producer;

    public TraceValue(Trace trace, int eventID, Instruction producer) {
        super(trace);
        this.eventID = eventID;
        this.producer = producer;
    }

    @Override
    public int getEventID() {
        return this.eventID;
    }

    public Instruction getProducer() {
        return this.producer;
    }

    @Override
    public boolean getBoolean() throws NoValueException {
        if (this.trace.getKind((int)this.eventID).isNonArgumentDefinition) {
            return this.trace.getDefinitionValueSet(this.eventID).getBoolean();
        }
        return this.trace.getBooleanProduced(this.eventID);
    }

    @Override
    public int getInteger() throws NoValueException {
        if (this.trace.getKind((int)this.eventID).isNonArgumentDefinition) {
            return this.trace.getDefinitionValueSet(this.eventID).getInteger();
        }
        return this.trace.getIntegerProduced(this.eventID);
    }

    @Override
    public long getLong() {
        if (this.trace.getKind((int)this.eventID).isNonArgumentDefinition) {
            Value value = this.trace.getDefinitionValueSet(this.eventID);
            return value == null ? 0L : value.getLong();
        }
        return this.trace.getLongProduced(this.eventID);
    }

    @Override
    public float getFloat() throws NoValueException {
        if (this.trace.getKind((int)this.eventID).isNonArgumentDefinition) {
            return this.trace.getDefinitionValueSet(this.eventID).getFloat();
        }
        return this.trace.getFloatProduced(this.eventID);
    }

    @Override
    public double getDouble() throws NoValueException {
        if (this.trace.getKind((int)this.eventID).isNonArgumentDefinition) {
            return this.trace.getDefinitionValueSet(this.eventID).getDouble();
        }
        return this.trace.getDoubleProduced(this.eventID);
    }

    @Override
    public Object getValue() throws NoValueException {
        EventKind kind = this.trace.getKind(this.eventID);
        if (kind.isValueProduced || kind.isArgument) {
            switch (kind) {
                case INTEGER_PRODUCED: 
                case INTEGER_ARG: {
                    return this.getInteger();
                }
                case SHORT_PRODUCED: 
                case SHORT_ARG: {
                    return this.trace.getShortProduced(this.eventID);
                }
                case BYTE_PRODUCED: 
                case BYTE_ARG: {
                    return this.trace.getByteProduced(this.eventID);
                }
                case FLOAT_PRODUCED: 
                case FLOAT_ARG: {
                    return Float.valueOf(this.trace.getFloatProduced(this.eventID));
                }
                case BOOLEAN_PRODUCED: 
                case BOOLEAN_ARG: {
                    return this.trace.getBooleanProduced(this.eventID);
                }
                case CHARACTER_PRODUCED: 
                case CHARACTER_ARG: {
                    return Character.valueOf(this.trace.getCharacterProduced(this.eventID));
                }
                case DOUBLE_PRODUCED: 
                case DOUBLE_ARG: {
                    return this.trace.getDoubleProduced(this.eventID);
                }
                case LONG_PRODUCED: 
                case LONG_ARG: {
                    return this.trace.getLongProduced(this.eventID);
                }
                case OBJECT_PRODUCED: 
                case NEW_OBJECT: 
                case NEW_ARRAY: 
                case OBJECT_ARG: {
                    return this.trace.getObjectIDProduced(this.eventID);
                }
            }
            throw new RuntimeException("\n\n" + this.trace.eventToString(this.eventID) + " \n\nis an unknown type of trace stack value.");
        }
        if (kind.isDefinition) {
            return this.trace.getDefinitionValueSet(this.eventID).getValue();
        }
        throw new RuntimeException("Don't know how to get a trace stack value for  " + (Object)((Object)kind));
    }

    @Override
    public Object getImmutable() throws NoValueException {
        EventKind kind = this.trace.getKind(this.eventID);
        if (kind.isObjectProduced || kind.isArgument) {
            long objectID = this.trace.getObjectIDProduced(this.eventID);
            return this.trace.getImmutableObject(objectID);
        }
        if (kind.isDefinition) {
            return this.trace.getDefinitionValueSet(this.eventID).getImmutable();
        }
        return null;
    }

    @Override
    public boolean isObject() {
        EventKind kind = this.trace.getKind(this.eventID);
        if (kind.isObjectProduced || kind == EventKind.OBJECT_ARG) {
            return true;
        }
        if (kind.isDefinition) {
            Value val = this.trace.getDefinitionValueSet(this.eventID);
            return val == null ? false : val.isObject();
        }
        return false;
    }

    @Override
    public String getVerbalExplanation() {
        return this.trace.getHTMLDescription(this.eventID);
    }

    @Override
    public String getDisplayName(boolean html) {
        Object value = null;
        try {
            value = this.getValue();
        }
        catch (NoValueException e) {
            return "[unknown]";
        }
        if (this.isObject()) {
            if (value == null) {
                return "null";
            }
            Object immutable = null;
            try {
                immutable = this.getImmutable();
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            if (immutable != null) {
                return Util.format(immutable, html);
            }
            long val = (Long)value;
            return this.trace.getDescriptionOfObjectID(val);
        }
        return Util.format(value, html);
    }

    @Override
    public boolean hasEventID() {
        return true;
    }

    public String toString() {
        return "TraceStackValue:" + this.trace.eventToString(this.eventID);
    }

    @Override
    public Answer getAnswer(Question<?> q) {
        return new CauseAnswer(q, this.eventID, "These events were responsible.");
    }
}

