/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.ThreadMetaData;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceMetaData {
    private final QualifiedClassName mainClassName;
    private final List<String> mainArguments;
    private final long timeOfInvocation;
    private final int numberOfEvents;
    private final long numberOfObjects;
    private final int numberOfClasses;
    private final int numberOfThreads;
    private final ThreadMetaData[] threadMetaData;
    private MethodInfo main;

    public TraceMetaData(File file) throws IOException {
        DataInputStream data = Util.getReaderFor(file);
        this.mainClassName = QualifiedClassName.get(data.readUTF());
        this.mainArguments = new ArrayList<String>(5);
        int numberOfArgs = data.readInt();
        int i = 0;
        while (i < numberOfArgs) {
            this.mainArguments.add(data.readUTF());
            ++i;
        }
        this.timeOfInvocation = data.readLong();
        this.numberOfEvents = data.readInt();
        assert (this.numberOfEvents <= Integer.MAX_VALUE) : "The number of events exceeds the largest possible array we can create.";
        this.numberOfObjects = data.readLong();
        this.numberOfClasses = data.readInt();
        this.numberOfThreads = data.readInt();
        this.threadMetaData = new ThreadMetaData[this.numberOfThreads];
        i = 0;
        while (i < this.numberOfThreads) {
            this.threadMetaData[i] = new ThreadMetaData(data);
            ++i;
        }
        data.close();
    }

    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    public long getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public Iterable<String> getMainArguments() {
        return this.mainArguments;
    }

    public ThreadMetaData getThreadMetaData(int i) {
        return this.threadMetaData[i];
    }

    public MethodInfo getMain(Trace trace) {
        if (this.main == null) {
            Classfile classfileWithMain = trace.getClassfileByName(this.mainClassName);
            this.main = classfileWithMain != null ? classfileWithMain.getMain() : null;
        }
        return this.main;
    }
}

