/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.bytecode.FieldrefInfo;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public final class StaticVariableAssignmentHistory
implements Saveable {
    private final Trace trace;
    private final HashMap<String, IntegerVector> assignmentIDsByField = new HashMap(100);

    public StaticVariableAssignmentHistory(Trace trace) {
        this.trace = trace;
    }

    public void addStaticAssignmentID(int assignmentID) {
        FieldrefInfo ref = ((FieldrefContainer)((Object)this.trace.getInstruction(assignmentID))).getFieldref();
        IntegerVector vector = this.assignmentIDsByField.get(ref.getQualifiedName());
        if (vector == null) {
            vector = new IntegerVector(10);
            this.assignmentIDsByField.put(ref.getQualifiedName(), vector);
        }
        vector.append(assignmentID);
    }

    public int getLastDefinitionOfBefore(String qualifiedFieldName, int eventIDBefore) {
        IntegerVector assignmentIDs = this.assignmentIDsByField.get(qualifiedFieldName);
        if (assignmentIDs == null) {
            return -1;
        }
        int index = assignmentIDs.getIndexOfLargestValueLessThanOrEqualTo(eventIDBefore);
        if (index >= 0) {
            return assignmentIDs.get(index);
        }
        return -1;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.assignmentIDsByField.size());
        for (String field : this.assignmentIDsByField.keySet()) {
            out.writeUTF(field);
            this.assignmentIDsByField.get(field).write(out);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.assignmentIDsByField.put(in.readUTF(), new IntegerVector(in));
            ++i;
        }
    }
}

