/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKSource {
    private static JarFile sourceJAR;
    private static Map<String, JavaSourceFile> sourceByName;
    private static Set<String> knownSourceFileNames;
    private static String lastPathIndexed;

    static {
        sourceByName = new HashMap<String, JavaSourceFile>();
        lastPathIndexed = null;
    }

    private static Set<String> getSourceFileNames() {
        JDKSource.indexSource();
        return knownSourceFileNames;
    }

    public static JavaSourceFile getSourceFor(Classfile classfile) {
        JDKSource.indexSource();
        if (!classfile.hasSourceFileAttribute()) {
            return null;
        }
        String qualifiedName = classfile.getQualifiedSourceFileName();
        return qualifiedName == null ? null : JDKSource.getSourceForQualifiedName(qualifiedName);
    }

    private static void indexSource() {
        try {
            String sourcePath = Whyline.getJDKSourcePath();
            if (lastPathIndexed != null && sourcePath != null && !lastPathIndexed.equals(sourcePath)) {
                knownSourceFileNames = null;
            } else {
                lastPathIndexed = sourcePath;
            }
            if (knownSourceFileNames != null) {
                return;
            }
            knownSourceFileNames = new HashSet<String>();
            if (sourcePath == null) {
                return;
            }
            File sourceJARFile = new File(sourcePath);
            if (!sourceJARFile.exists()) {
                return;
            }
            sourceJAR = new JarFile(sourceJARFile);
            Enumeration<JarEntry> e = sourceJAR.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().endsWith(".java")) continue;
                assert (entry.getName().startsWith("src/")) : "I don't know how to handle jar entry names that don't start with \"src/\" because I can't parse the package name.";
                String filename = entry.getName().substring(4);
                knownSourceFileNames.add(filename);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JavaSourceFile getSourceForQualifiedName(String qualifiedSourcefileName) {
        JavaSourceFile source = sourceByName.get(qualifiedSourcefileName);
        if (source == null && JDKSource.getSourceFileNames().contains(qualifiedSourcefileName)) {
            source = JDKSource.findAndLoadSource(qualifiedSourcefileName);
        }
        return source;
    }

    public static int getNumberOfSourceFilesKnown() {
        return JDKSource.getSourceFileNames().size();
    }

    public static Collection<JavaSourceFile> getAllSource() {
        for (String name : JDKSource.getSourceFileNames()) {
            JDKSource.findAndLoadSource(name);
        }
        return Collections.unmodifiableCollection(sourceByName.values());
    }

    public static JavaSourceFile findAndLoadSource(String qualifiedName) {
        if (sourceJAR == null) {
            return null;
        }
        JavaSourceFile sf = sourceByName.get(qualifiedName);
        if (sf != null) {
            return sf;
        }
        try {
            ZipEntry entry = sourceJAR.getEntry("src/" + qualifiedName);
            DataInputStream stream = new DataInputStream(sourceJAR.getInputStream(entry));
            byte[] bytes = new byte[(int)entry.getSize()];
            stream.readFully(bytes);
            sf = new JavaSourceFile(qualifiedName, bytes, false);
            if (sourceByName.containsKey(qualifiedName)) {
                throw new RuntimeException("Ahhhh! Two source files with the same name! " + qualifiedName);
            }
            sourceByName.put(qualifiedName, sf);
            return sf;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

