/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.ClassBodyElement;
import edu.cmu.hcii.whyline.source.ClassElement;
import edu.cmu.hcii.whyline.source.FileElement;
import edu.cmu.hcii.whyline.source.JavaParserConstants;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.JavaTokenizer;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;

public final class JavaParser
implements JavaParserConstants {
    private final JavaSourceFile source;
    private String string = null;
    private final Line[] lines;
    private final Token[] code;
    private final Token[] identifiers;
    private final TObjectIntHashMap<Line> codeTokenIndicesByLine;
    private final FileElement file;
    private final Map<Token, String> javadocs;

    public JavaParser(JavaSourceFile source, byte[] bytes) throws ParseException {
        this.source = source;
        JavaTokenizer tokenizer = new JavaTokenizer(source, bytes);
        this.lines = tokenizer.getLines();
        this.codeTokenIndicesByLine = tokenizer.getCodeTokenIndiciesByLine();
        this.identifiers = tokenizer.getIdentifiers();
        this.code = tokenizer.getCode();
        this.javadocs = tokenizer.getJavaDocsByToken();
        if (this.lines != null) {
            StringBuilder builder = new StringBuilder();
            Line[] lineArray = this.lines;
            int n = this.lines.length;
            int n2 = 0;
            while (n2 < n) {
                Line line = lineArray[n2];
                for (Token token : line.getTokens()) {
                    builder.append(token.getText());
                }
                ++n2;
            }
            this.string = builder.toString();
        } else {
            this.string = new String(bytes);
        }
        this.file = new FileElement(source, this.code[0], this.code[this.code.length - 1]);
    }

    public String getString() {
        return this.string;
    }

    public Line[] getLines() {
        return this.lines;
    }

    public Token[] getIdentifiers() {
        return this.identifiers;
    }

    public Token[] getCodeTokens() {
        return this.code;
    }

    public TokenIterator getTokenIterator(Token first, Token last) throws ParseException {
        return new TokenIterator(first, last);
    }

    private int getIndexOfCodeToken(Token token) {
        if (!token.isCode()) {
            return -1;
        }
        Line line = token.getLine();
        int lineIndex = line.getIndexOfCodeToken(token);
        assert (lineIndex >= 0);
        int firstIndex = this.codeTokenIndicesByLine.get(line);
        int indexOfCodeToken = firstIndex + lineIndex;
        return indexOfCodeToken;
    }

    private int getIndexOfCodeTokenAtOrAfter(Token token) throws ParseException {
        if (token.isCode()) {
            return this.getIndexOfCodeToken(token);
        }
        Token code = token.getLine().getCodeTokenAtOrAfter(token);
        if (code != null) {
            return this.getIndexOfCodeToken(code);
        }
        Line line = token.getLine().getLineAfter();
        while (line != null) {
            code = line.getFirstCodeToken();
            if (code != null) {
                return this.getIndexOfCodeToken(code);
            }
            line = line.getLineAfter();
        }
        return -1;
    }

    public boolean isCodeTokenBeforeCodeToken(Token token, Token tokenBefore) {
        return this.getIndexOfCodeToken(token) < this.getIndexOfCodeToken(tokenBefore);
    }

    public Token getCodeTokenAfter(Token token) {
        if (token == null) {
            return null;
        }
        assert (token.getLine().getFile() == this.source) : "But this token \"" + token + "\" isn't in this file " + this.source;
        int index = this.getIndexOfCodeToken(token);
        if (index < 0) {
            return null;
        }
        if (index + 1 >= this.code.length) {
            return null;
        }
        return this.code[index + 1];
    }

    public Token getCodeTokenBefore(Token token) {
        if (token == null) {
            return null;
        }
        assert (token.getLine().getFile() == this.source) : "But this token \"" + token + "\" isn't in this file " + this.source;
        int index = this.getIndexOfCodeToken(token);
        if (index - 1 < 0) {
            return null;
        }
        return this.code[index - 1];
    }

    public ClassElement getClassElement(Classfile classfile) {
        return this.file.getClassElement(classfile);
    }

    public void parseBlocks() {
        this.file.parseBlocks();
    }

    public ClassBodyElement getFieldElement(FieldInfo field) {
        ClassElement c = this.getClassElement(field.getClassfile());
        ClassBodyElement f = c == null ? null : c.getFieldElement(field);
        return f;
    }

    public ClassBodyElement getMethodElement(MethodInfo method) {
        ClassElement c = this.getClassElement(method.getClassfile());
        ClassBodyElement m = c == null ? null : c.getMethodElement(method);
        return m;
    }

    public final class TokenIterator {
        private int nextIndex;
        private int lastIndex;

        public TokenIterator(Token first, Token last) throws ParseException {
            assert (first != null);
            this.nextIndex = JavaParser.this.getIndexOfCodeTokenAtOrAfter(first);
            int n = this.lastIndex = last == null ? -1 : JavaParser.this.getIndexOfCodeTokenAtOrAfter(last);
            if (this.lastIndex < 0) {
                this.lastIndex = JavaParser.this.code.length - 1;
            } else if (!last.isCode()) {
                --this.lastIndex;
            }
        }

        public boolean nextKindIs(int kind) {
            return ((JavaParser)JavaParser.this).code[this.nextIndex].kind == kind;
        }

        public boolean hasKindBefore(int kind, int stoppingKind) {
            int stopIndex = this.lastIndex < 0 ? JavaParser.this.code.length : this.lastIndex;
            int i = this.nextIndex;
            while (i < this.lastIndex) {
                int currentKind = ((JavaParser)JavaParser.this).code[i].kind;
                if (currentKind == kind) {
                    return true;
                }
                if (currentKind == stoppingKind) {
                    return false;
                }
                ++i;
            }
            return false;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0 && this.nextIndex <= this.lastIndex;
        }

        public Token getNext() throws ParseException {
            if (this.nextIndex >= JavaParser.this.code.length) {
                throw new ParseException("There was no next token...", this);
            }
            return JavaParser.this.code[this.nextIndex++];
        }

        public Token getNext(int kind) throws ParseException {
            Token t = this.getNext();
            if (t.kind != kind) {
                throw new ParseException("Expected a " + JavaParserConstants.tokenImage[kind] + " but found " + t, this);
            }
            return t;
        }

        public Token.PairedToken nextPaired(int kind) throws ParseException {
            Token t = this.getNext();
            if (t.kind != kind) {
                throw new ParseException("Expected " + JavaParserConstants.tokenImage[kind], this);
            }
            if (t instanceof Token.PairedToken) {
                return (Token.PairedToken)t;
            }
            throw new ParseException("Expected paired token", this);
        }

        public Token.PairedToken peekPaired() throws ParseException {
            Token t = this.peek();
            if (t instanceof Token.PairedToken) {
                return (Token.PairedToken)t;
            }
            throw new ParseException("Expected paired token", this);
        }

        public Token.PairedToken peekPairedPartner() throws ParseException {
            Token t = this.peek();
            if (t instanceof Token.PairedToken) {
                return ((Token.PairedToken)t).getAssociatedToken();
            }
            throw new ParseException("Expected paired token", this);
        }

        public boolean nextIsModifier() {
            return JavaParser.this.code[this.nextIndex].isModifier();
        }

        public Token jumpPastNext(int kind) throws ParseException {
            while (this.hasNext() && !this.nextKindIs(kind)) {
                this.getNext();
            }
            if (this.hasNext()) {
                return this.getNext();
            }
            return null;
        }

        public Token getNextOr(int kind1, int kind2) throws ParseException {
            while (this.hasNext() && !this.nextKindIs(kind1) && !this.nextKindIs(kind2)) {
                this.getNext();
            }
            if (this.hasNext()) {
                return this.getNext();
            }
            return null;
        }

        public Token peek() {
            return this.nextIndex >= JavaParser.this.code.length ? null : JavaParser.this.code[this.nextIndex];
        }

        public Token peekNext() {
            return this.hasNext() ? JavaParser.this.code[this.nextIndex + 1] : null;
        }

        public Token peekNext(int kind) {
            int i = this.nextIndex;
            while (i < JavaParser.this.code.length) {
                if (((JavaParser)JavaParser.this).code[i].kind == kind) {
                    return JavaParser.this.code[i];
                }
                ++i;
            }
            return null;
        }

        public Token peekBeforeNext(int kind) {
            int i = this.nextIndex;
            while (i < JavaParser.this.code.length - 1) {
                if (((JavaParser)JavaParser.this).code[i + 1].kind == kind) {
                    return JavaParser.this.code[i];
                }
                ++i;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public void jumpPast(Token token) throws ParseException {
            if (TokenIterator.$assertionsDisabled || token != null) ** GOTO lbl5
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                this.getNext();
lbl5:
                // 2 sources

                ** while (this.hasNext() && this.peek() != token)
            }
lbl6:
            // 1 sources

            if (!this.hasNext() || this.peek() != token) {
                throw new ParseException("Expected to find specific '" + token + "'", this);
            }
            this.getNext();
        }

        public String toString() {
            return JavaParser.this.code[this.nextIndex].getLine() + "\n\tprevious = " + (this.nextIndex > 0 ? JavaParser.this.code[this.nextIndex - 1] : "null") + "\n\tnext = " + (this.hasNext() ? this.peek() : "null");
        }

        public boolean nextIsPrimitive() {
            return this.peek().isPrimitive();
        }
    }
}

