/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.ClassBodyElement;
import edu.cmu.hcii.whyline.source.ClassElement;
import edu.cmu.hcii.whyline.source.ClassElementContainer;
import edu.cmu.hcii.whyline.source.JavaElement;
import edu.cmu.hcii.whyline.source.JavaParser;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import java.util.ArrayList;
import java.util.List;

public class FileElement
extends JavaElement
implements ClassElementContainer {
    private final JavaSourceFile source;
    private final List<ClassElement> classes = new ArrayList<ClassElement>(1);

    public FileElement(JavaSourceFile source, Token first, Token last) {
        super(null, first, last);
        this.source = source;
    }

    public FileElement getRoot() {
        return this;
    }

    public JavaSourceFile getSource() {
        return this.source;
    }

    public ClassElement getClassElement(Classfile classfile) {
        String[] stringArray;
        String name = classfile.getInternalName().getSimpleClassQualifiedName();
        if (name.indexOf(36) >= 0) {
            stringArray = name.split("\\$");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        String[] path = stringArray;
        JavaElement classContainer = this;
        int index = 0;
        while (index < path.length) {
            classContainer = classContainer.getClassBySimpleName(path[index]);
            ++index;
        }
        return (ClassElement)classContainer;
    }

    public ClassElement getClassBySimpleName(String name) {
        this.parse();
        for (ClassElement c : this.classes) {
            if (!c.getSimpleName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public ClassBodyElement getMethodElement(MethodInfo method) {
        this.parse();
        ClassElement c = this.getClassElement(method.getClassfile());
        return c == null ? null : c.getMethodElement(method);
    }

    protected void parse(JavaParser.TokenIterator tokens) throws ParseException {
        if (tokens.nextKindIs(45)) {
            this.packageDeclaration(tokens);
        }
        while (tokens.hasNext() && tokens.nextKindIs(37)) {
            this.importDeclaration(tokens);
        }
        while (tokens.hasKindBefore(20, 81) || tokens.hasKindBefore(40, 81) || tokens.hasKindBefore(27, 81)) {
            Token firstClassToken = tokens.getNext();
            while (tokens.hasNext() && !tokens.nextKindIs(81)) {
                tokens.getNext();
            }
            Token.PairedToken openBrace = (Token.PairedToken)tokens.getNext();
            Token.PairedToken closingBrace = openBrace.getAssociatedToken();
            assert (closingBrace != null) : "Couldn't find a closing brace at " + tokens;
            ClassElement classElement = new ClassElement(this, firstClassToken, closingBrace, false);
            this.classes.add(classElement);
            tokens.jumpPast(closingBrace);
        }
    }

    private void packageDeclaration(JavaParser.TokenIterator tokens) throws ParseException {
        while (tokens.hasNext() && !tokens.nextKindIs(85)) {
            tokens.getNext();
        }
        tokens.getNext();
    }

    private void importDeclaration(JavaParser.TokenIterator tokens) throws ParseException {
        while (tokens.hasNext() && !tokens.nextKindIs(85)) {
            tokens.getNext();
        }
        tokens.getNext();
    }

    public void parseBlocks() {
        for (ClassElement element : this.classes) {
            element.parseBlocks();
        }
    }

    public String toString() {
        return "FileElement: " + this.source;
    }
}

