/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.INVOKESPECIAL;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.source.Decompiler;
import edu.cmu.hcii.whyline.source.Token;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression<T extends Instruction> {
    protected final T code;
    private final Decompiler decompiler;
    protected Token first;
    protected Token last;
    private final ArrayList<Expression<?>>[] argumentExpressions;
    private boolean hasArguments;

    public Expression(Decompiler decompiler, T code) {
        this.decompiler = decompiler;
        this.code = code;
        this.argumentExpressions = new ArrayList[((Instruction)code).getNumberOfArgumentProducers()];
        this.hasArguments = false;
        int arg = 0;
        while (arg < ((Instruction)code).getNumberOfArgumentProducers()) {
            StackDependencies.Producers producers = ((Instruction)code).getProducersOfArgument(arg);
            Instruction[] prods = producers.getProducers();
            if (prods != null) {
                this.argumentExpressions[arg] = new ArrayList(1);
                Instruction[] instructionArray = prods;
                int n = prods.length;
                int n2 = 0;
                while (n2 < n) {
                    Instruction producer = instructionArray[n2];
                    this.argumentExpressions[arg].add(decompiler.getExpression((Instruction)code, producer));
                    this.hasArguments = true;
                    ++n2;
                }
            }
            ++arg;
        }
    }

    public Instruction getCode() {
        return this.code;
    }

    public abstract String getJavaName();

    public abstract boolean mayAppearInSource();

    public abstract boolean alwaysAppearsInSource();

    protected final Token parse(List<Token> tokens) {
        this.first = tokens.isEmpty() ? null : tokens.get(0);
        this.last = this.parseHelper(tokens);
        if (this.first != null && this.last != null) {
            this.decompiler.getSource().linkInstructionWithTokenRange((Instruction)this.code, this.first, this.last);
        }
        return this.last;
    }

    protected abstract Token parseHelper(List<Token> var1);

    protected Token parseArgument(List<Token> tokens, int arg) {
        if (arg < 0 || arg >= this.argumentExpressions.length) {
            return null;
        }
        ArrayList<Expression<?>> args = this.argumentExpressions[arg];
        Token last = null;
        if (args != null) {
            for (Expression expression : args) {
                if (expression == null) continue;
                last = expression.parse(tokens);
            }
        }
        return last;
    }

    protected Token parseThis(List<Token> tokens) {
        Token token;
        if (this.code instanceof NEW && ((NEW)this.code).getClassnameOfTypeProduced() == QualifiedClassName.STRING_BUILDER && !tokens.isEmpty() && tokens.get((int)0).kind != 43) {
            return tokens.get(0);
        }
        if (this.code instanceof INVOKESPECIAL && ((INVOKESPECIAL)this.code).getMethodInvoked().matchesClassAndName(QualifiedClassName.STRING_BUILDER, "<init>") && !tokens.isEmpty() && !tokens.get(0).getText().equals("StringBuilder")) {
            return tokens.get(0);
        }
        Token token2 = token = tokens.isEmpty() ? null : tokens.remove(0);
        if (token != null) {
            this.decompiler.getSource().linkTokenWithInstruction(token, (Instruction)this.code);
        }
        return token;
    }

    public int getNumberOfArguments() {
        return ((Instruction)this.code).getNumberOfArgumentProducers();
    }

    public boolean hasOperands() {
        return this.hasArguments;
    }

    public final String toString() {
        if (((Instruction)this.code).getNumberOfOperandsConsumed() == 0) {
            return this.getJavaName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.getJavaName());
        ArrayList<Expression<?>>[] arrayListArray = this.argumentExpressions;
        int n = this.argumentExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<Expression<?>> args = arrayListArray[n2];
            for (Expression<?> expr : args) {
                builder.append(" ");
                builder.append(expr);
            }
            ++n2;
        }
        builder.append(")");
        return builder.toString();
    }
}

