/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.io.OutputEvent;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;

public final class TextualOutputEvent
extends OutputEvent {
    private final String stringPrinted;
    private boolean isResultOfStringBuilder = false;
    private boolean isArgumentOfPrint = false;
    private boolean appendsNewline = false;

    public TextualOutputEvent(Trace trace, int eventID) {
        super(trace, eventID);
        Object value;
        Invoke invoke;
        boolean parameterToWriter = false;
        Instruction producerInstruction = trace.getInstruction(eventID);
        StackDependencies.Consumers consumers = producerInstruction.getConsumers();
        if (consumers.getFirstConsumer() instanceof Invoke) {
            invoke = (Invoke)consumers.getFirstConsumer();
            this.isArgumentOfPrint = invoke.getMethodInvoked().matchesClassAndName(QualifiedClassName.PRINT_STREAM, "println") || invoke.getMethodInvoked().matchesClassAndName(QualifiedClassName.PRINT_STREAM, "print");
            this.appendsNewline = invoke.getMethodInvoked().getMethodName().equals("println");
            parameterToWriter = trace.getClassIDs().isOrIsSubclassOf(invoke.getMethodInvoked().getClassName(), QualifiedClassName.WRITER);
        }
        if (this.isArgumentOfPrint && producerInstruction instanceof Invoke) {
            invoke = (Invoke)producerInstruction;
            this.isResultOfStringBuilder = invoke.getMethodInvoked().matchesClassAndName(QualifiedClassName.STRING_BUILDER, "toString");
        }
        boolean producerIsObjectProduced = trace.getKind(eventID) == EventKind.OBJECT_PRODUCED;
        String regularValue = trace.getDescription(eventID);
        Object objectValue = producerIsObjectProduced ? trace.getObjectProduced(eventID) : null;
        Object object = value = producerIsObjectProduced ? objectValue : regularValue;
        if (this.isResultOfStringBuilder) {
            this.stringPrinted = "\n";
        } else if (this.isArgumentOfPrint) {
            this.stringPrinted = value + "\n";
        } else {
            if (parameterToWriter) {
                long arrayID;
                QualifiedClassName classname;
                if (value instanceof Integer) {
                    value = Character.valueOf((char)((Integer)value).intValue());
                } else if (producerIsObjectProduced && regularValue instanceof Long && (classname = trace.getClassnameOfObjectID(arrayID = ((Long)((Object)regularValue)).longValue())).isArray()) {
                    classname.getText().equals("[C");
                }
            } else if (producerIsObjectProduced && regularValue instanceof Long) {
                long id = (Long)((Object)regularValue);
                QualifiedClassName type = trace.getClassnameOfObjectID(id);
                StringBuilder builder = new StringBuilder();
                builder.append(type.getSimpleName());
                builder.append(" #");
                builder.append(id);
                value = builder.toString();
            }
            this.stringPrinted = value + (this.appendsNewline ? "\n" : "");
        }
    }

    public boolean segmentsOutput() {
        return !this.isResultOfStringBuilder;
    }

    public String getStringPrinted() {
        return this.stringPrinted;
    }

    public String getHTMLDescription() {
        return "\"" + this.stringPrinted + "\"" + " printed";
    }

    public String toString() {
        return "println \"" + this.getStringPrinted().replace("\n", "\\n") + "\"";
    }
}

