/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.io.GraphicalOutputEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.io.GraphicsContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderEvent
extends GraphicalOutputEvent
implements Comparable<RenderEvent> {
    protected GraphicsContext paintState;
    private Shape unclippedShape = null;
    private Rectangle clippedBoundaries = null;
    private RenderEvent occluder;
    private List<DrawImageEvent> renderers = null;

    public RenderEvent(Trace trace, int eventID) {
        super(trace, eventID);
        this.getInstanceResponsible();
    }

    @Override
    public String getHTMLDescription() {
        return this.getHumanReadableName();
    }

    public void setRenderers(List<DrawImageEvent> renderers) {
        this.renderers = renderers;
    }

    public List<DrawImageEvent> getRenderers() {
        return this.renderers;
    }

    public void paintByMemory() {
        Graphics2D g = this.paintState.getGraphics();
        this.paint(g);
    }

    @Override
    public abstract void paint(Graphics2D var1);

    public void rememberContext(GraphicsContext g) {
        this.paintState = new GraphicsContext(g);
    }

    public GraphicsContext getGraphicsState() {
        return this.paintState;
    }

    public boolean contains(int x, int y) {
        Rectangle bounds = this.getClippedBoundaries();
        if (bounds != null && !bounds.contains(x, y)) {
            return false;
        }
        Shape shape = this.getUnclippedShape();
        if (shape == null) {
            return false;
        }
        return this.getUnclippedShape().intersects(x - 1, y - 1, 2.0, 2.0);
    }

    public Shape getClip() {
        return this.paintState.getGraphics().getClip();
    }

    public boolean occludes(RenderEvent renderEvent) {
        Rectangle occludersClippedBoundaries = this.getClippedBoundaries();
        Rectangle eventsClippedBoundaries = renderEvent.getClippedBoundaries();
        if (occludersClippedBoundaries == null || eventsClippedBoundaries == null) {
            return false;
        }
        return occludersClippedBoundaries.contains(eventsClippedBoundaries);
    }

    public void setOccluder(RenderEvent re) {
        assert (this.occluder == null) : "We've already set an occluder on " + this;
        this.occluder = re;
    }

    public boolean isVisibleAfter(int eventID) {
        if (eventID < this.getEventID()) {
            return false;
        }
        if (this.occluder == null) {
            return true;
        }
        return this.occluder.getEventID() > eventID;
    }

    public boolean hasOccluder() {
        return this.occluder != null;
    }

    public RenderEvent getOccluder() {
        return this.occluder;
    }

    public abstract boolean canOcclude();

    protected abstract Shape makeShape();

    public Shape getUnclippedShape() {
        if (this.unclippedShape == null) {
            this.unclippedShape = this.makeShape();
        }
        return this.unclippedShape;
    }

    public Rectangle getClippedBoundaries() {
        if (this.clippedBoundaries != null) {
            return this.clippedBoundaries;
        }
        Shape clip = this.paintState.getGraphics().getClip();
        Shape unclippedShape = this.getUnclippedShape();
        if (clip == null) {
            return unclippedShape == null ? null : unclippedShape.getBounds();
        }
        if (unclippedShape == null) {
            return null;
        }
        Rectangle shapeRect = unclippedShape.getBounds();
        Rectangle clipRect = clip.getBounds();
        clipRect.translate(this.paintState.getOriginX(), this.paintState.getOriginY());
        this.clippedBoundaries = clipRect.intersection(shapeRect);
        return this.clippedBoundaries;
    }

    public abstract String getArgumentName(int var1);

    @Override
    public boolean segmentsOutput() {
        return false;
    }

    @Override
    public int compareTo(RenderEvent o) {
        return this.eventID - o.eventID;
    }
}

