/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Saveable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOHistory<T extends IOEvent>
implements Iterable<T>,
Saveable {
    private final ArrayList<T> events;
    private final Trace trace;
    private final IOHistory<? super T> parent;

    public IOHistory(IOHistory<? super T> parent, Trace trace) {
        this.parent = parent;
        this.trace = trace;
        this.events = new ArrayList(20000);
    }

    public void trimToSize() {
        this.events.trimToSize();
    }

    public void add(T event) {
        assert (this.events.isEmpty() || ((IOEvent)event).getEventID() > ((IOEvent)this.getLastEvent()).getEventID()) : "IO events must be added in order of occurrence.";
        this.events.add(event);
        if (this.parent != null) {
            this.parent.add(event);
        }
    }

    public int getNumberOfEvents() {
        return this.events.size();
    }

    public T getEventAtIndex(int index) {
        return (T)((IOEvent)this.events.get(index));
    }

    public T getMostRecentBeforeTime(int time) {
        int index = this.events.size() - 1;
        while (index >= 0) {
            IOEvent e = (IOEvent)this.events.get(index);
            if (e.getEventID() < time) {
                return (T)e;
            }
            --index;
        }
        return null;
    }

    public T getEventAtTime(int time) {
        int index = this.events.size() - 1;
        while (index >= 0) {
            IOEvent e = (IOEvent)this.events.get(index);
            if (e.getEventID() == time) {
                return (T)e;
            }
            --index;
        }
        return null;
    }

    public T getNextAfterTime(int time) {
        int index = 0;
        while (index < this.events.size()) {
            IOEvent e = (IOEvent)this.events.get(index);
            if (e.getEventID() > time) {
                return (T)e;
            }
            ++index;
        }
        return null;
    }

    public T getLastEvent() {
        return (T)(this.events.size() > 0 ? (IOEvent)this.events.get(this.events.size() - 1) : null);
    }

    public T getFirstEvent() {
        return (T)(this.events.size() > 0 ? (IOEvent)this.events.get(0) : null);
    }

    @Override
    public Iterator<T> iterator() {
        return this.events.iterator();
    }

    public Iterable<T> getIteratorForEventsAfter(T event) {
        return new EventsBeforeOrAfterIterator(this, true, event);
    }

    public Iterable<T> getIteratorForEventsBefore(T event) {
        return new EventsBeforeOrAfterIterator(this, false, event);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.getNumberOfEvents());
        for (IOEvent io : this.events) {
            out.writeInt(io.getEventID());
        }
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("We write an IOHistory in IOHistory, but we read it in Trace.Loader");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventsBeforeOrAfterIterator
    implements Iterator<T>,
    Iterable<T> {
        private final boolean forward;
        private int historyIndex;
        final /* synthetic */ IOHistory this$0;

        public EventsBeforeOrAfterIterator(boolean forward, T startEvent) {
            this.this$0 = var1_1;
            this.forward = forward;
            int n = this.historyIndex = startEvent == null ? 0 : ((IOHistory)var1_1).events.indexOf(startEvent);
            if (this.historyIndex < 0) {
                this.historyIndex = -1;
            }
            this.next();
        }

        @Override
        public boolean hasNext() {
            if (this.historyIndex < 0) {
                return false;
            }
            return this.forward ? this.historyIndex <= this.this$0.events.size() - 1 : this.historyIndex >= 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                return null;
            }
            IOEvent nextEvent = (IOEvent)this.this$0.events.get(this.historyIndex);
            this.historyIndex += this.forward ? 1 : -1;
            return nextEvent;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove from IOHistory.");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

