/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public final class DrawImageWithLocationSizeAndObserverEvent
extends DrawImageEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "image", "x", "y", "width", "height", "observer"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawImageWithLocationSizeAndObserverEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paintWithImage(Graphics2D g, Image image) {
        if (image == null) {
            this.drawPlaceholder(g, "image " + this.getImageID(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
        } else {
            g.drawImage(image, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
        }
    }

    protected Shape makeShape() {
        return new Rectangle(this.paintState.getOriginX() + this.getX(), this.paintState.getOriginY() + this.getY(), this.getWidth(), this.getHeight());
    }

    public void transformContextToDrawPrimitive(Graphics2D g) {
        Image image = this.getGraphicsState().getWindowState().getImage(this.getImageID());
        g.scale((double)this.getWidth() / (double)image.getWidth(null), (double)this.getHeight() / (double)image.getHeight(null));
        g.translate(this.paintState.getOriginX() + this.getX(), this.paintState.getOriginY() + this.getY());
    }

    public int getWindowX() {
        return this.paintState.getOriginX() + this.getX();
    }

    public int getWindowY() {
        return this.paintState.getOriginY() + this.getY();
    }

    public int getX() {
        return this.getInteger(2);
    }

    public int getY() {
        return this.getInteger(3);
    }

    public int getWidth() {
        return this.getInteger(4);
    }

    public int getHeight() {
        return this.getInteger(5);
    }

    public long getObserver() {
        return this.getLong(6);
    }

    public String getHumanReadableName() {
        return "scaled image";
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\tdrawImageWithLocationSizeAndObserver " + this.getImage() + " " + this.getX() + " " + this.getY() + " " + this.getObserver();
    }
}

