/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;

public final class DrawCharsEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "characters", "offset", "length", "x", "y"};
    private Graphics2D renderContext;
    private GlyphVector glyphs;
    private String string;

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawCharsEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    private void fillChars(Graphics2D g) {
        if (this.glyphs != null) {
            return;
        }
        long charsID = this.getChars();
        int length = this.getLength();
        int offset = this.getOffset();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < length) {
            int indexInArray = offset + index;
            Object value = this.trace.getArrayAssignmentHistory().getValueOfIndexAtTime(charsID, indexInArray, this.getEventID());
            if (value != null) {
                builder.append(value instanceof Character ? ((Character)value).charValue() : (char)((Number)value).intValue());
            } else {
                builder.append('-');
            }
            ++index;
        }
        this.string = builder.toString();
        this.glyphs = g.getFont().createGlyphVector(g.getFontRenderContext(), this.string);
    }

    public void paint(Graphics2D g) {
        if (this.glyphs == null) {
            this.glyphs = g.getFont().createGlyphVector(g.getFontRenderContext(), Util.fillString('x', this.getLength()));
        }
        if (this.renderContext == null) {
            this.renderContext = g;
        }
        g.drawGlyphVector(this.glyphs, this.getX(), this.getY());
    }

    protected Shape makeShape() {
        if (this.glyphs == null) {
            return null;
        }
        Rectangle2D bounds = this.glyphs.getLogicalBounds();
        int ascent = this.renderContext.getFontMetrics(this.glyphs.getFont()).getAscent();
        return this.glyphs.getOutline(this.getX() + this.paintState.getOriginX(), this.getY() + this.paintState.getOriginY());
    }

    public long getChars() {
        return this.getLong(1);
    }

    public int getOffset() {
        return this.getInteger(2);
    }

    public int getLength() {
        return this.getInteger(3);
    }

    public int getX() {
        return this.getInteger(4);
    }

    public int getY() {
        return this.getInteger(5);
    }

    public String getHumanReadableName() {
        return "characters";
    }

    public boolean canOcclude() {
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdrawChars " + this.getX() + " " + this.getY();
    }
}

