/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableBranch
extends Branch {
    public TableBranch(CodeAttribute method) {
        super(method);
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    public abstract Iterable<Instruction> getNonDefaultTargets();

    public abstract int getNumberOfNonDefaultTargets();

    @Override
    protected boolean determineIfLoop() {
        return false;
    }

    @Override
    public boolean couldJumpTo(Instruction instruction) {
        for (Instruction target : this.getNonDefaultTargets()) {
            if (target != instruction) continue;
            return true;
        }
        return false;
    }

    public final Instruction getInstructionAfterTable() throws AnalysisException {
        int furthestTarget = 0;
        for (Instruction target : this.getNonDefaultTargets()) {
            if (target.getIndex() <= furthestTarget) continue;
            furthestTarget = target.getIndex();
        }
        Instruction furthestTargetWithinTable = null;
        Instruction currentInstruction = this;
        while (currentInstruction.getIndex() < furthestTarget) {
            if (!((currentInstruction = currentInstruction.getNext()) instanceof Branch)) continue;
            Instruction target = ((Branch)currentInstruction).getTarget();
            if (furthestTargetWithinTable == null) {
                furthestTargetWithinTable = target;
                continue;
            }
            if (target.getIndex() <= furthestTargetWithinTable.getIndex()) continue;
            furthestTargetWithinTable = target;
        }
        if (furthestTargetWithinTable == null || furthestTargetWithinTable.getIndex() < furthestTarget) {
            furthestTargetWithinTable = this.getCode().getInstruction(furthestTarget);
        }
        return furthestTargetWithinTable;
    }

    @Override
    public String getTypeDescriptorOfArgument(int argIndex) {
        return "I";
    }
}

