/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.Cancelable;
import edu.cmu.hcii.whyline.analysis.ValueSource;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.trace.Trace;
import java.io.DataOutputStream;
import java.io.IOException;

public final class INVOKESPECIAL
extends Invoke {
    public INVOKESPECIAL(CodeAttribute method, MethodrefInfo methodInfo) {
        super(method, methodInfo);
    }

    public boolean isInstanceInitializer() {
        return this.methodInfo.getMethodName().equals("<init>");
    }

    public MethodInfo[] getPreciseMethodsCalled(Trace trace, Cancelable cancelable) {
        return trace.getMethodsFromReference(this);
    }

    public final int getOpcode() {
        return 183;
    }

    public int byteLength() {
        return 3;
    }

    public void toBytes(DataOutputStream code) throws IOException {
        code.writeByte(this.getOpcode());
        code.writeShort(this.methodInfo.getIndexInConstantPool());
    }

    public String getJavaMethodName() {
        boolean referencesThis;
        if (!this.isInstanceInitializer()) {
            return this.methodInfo.getMethodName();
        }
        QualifiedClassName enclosingClass = this.getMethod().getClassfile().getInternalName();
        QualifiedClassName classCalled = this.methodInfo.getClassName();
        StackDependencies.Producers producers = this.getProducersOfArgument(0);
        Instruction producer = producers.getFirstProducer();
        boolean bl = referencesThis = producer instanceof GetLocal && ((GetLocal)producer).getLocalID() == 0;
        if (!referencesThis) {
            return this.methodInfo.getClassName().getSimpleName();
        }
        if (enclosingClass == classCalled) {
            return "this";
        }
        return "super";
    }

    public boolean couldCallOn(ValueSource typeOfThis, Trace trace) {
        return true;
    }
}

