/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ATHROW;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.Instruction;

public final class ExceptionHandler {
    private Instruction startPC;
    private Instruction endPC;
    private Instruction handlerPC;
    private final ClassInfo type;

    public ExceptionHandler(Instruction startPC, Instruction endPC, Instruction handlerPC, int catchType) {
        this.startPC = startPC;
        this.endPC = endPC;
        this.handlerPC = handlerPC;
        this.type = catchType == 0 ? null : (startPC == null ? null : (ClassInfo)startPC.getMethod().getClassfile().getConstantPool().get(catchType));
    }

    public boolean handles(Instruction i) {
        return i.getIndex() >= this.startPC.getIndex() && i.getIndex() < this.endPC.getIndex();
    }

    public Instruction getStartPC() {
        return this.startPC;
    }

    public Instruction getEndPC() {
        return this.endPC;
    }

    public Instruction getHandlerPC() {
        return this.handlerPC;
    }

    public int getCatchTypeIndex() {
        return this.type == null ? 0 : this.type.getIndexInConstantPool();
    }

    public ClassInfo getCatchType() {
        return this.type;
    }

    public boolean handles(ATHROW athrow) {
        return this.startPC.getByteIndex() <= athrow.getByteIndex() && (this.endPC == null || this.endPC.getByteIndex() > athrow.getByteIndex());
    }

    public void updateHandlerPC(Instruction newHandler) {
        this.handlerPC = newHandler;
    }

    public void updateStartPC(Instruction newStart) {
        this.startPC = newStart;
    }

    public void updateEndPC(Instruction newEnd) {
        this.endPC = newEnd;
    }

    public String toString() {
        return String.valueOf(this.type == null ? "finally:" : "catch(" + this.type + "):") + "\nstarts " + this.startPC + "\nends   " + this.endPC + "\nis at  " + this.handlerPC;
    }
}

