/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.GOTO;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.UnconditionalBranch;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConditionalBranch
extends Branch {
    private int offset;
    private Instruction trueDestination;
    private Instruction falseDestination;

    public ConditionalBranch(CodeAttribute method, int offset) {
        super(method);
        this.offset = offset;
    }

    @Override
    public boolean couldJumpTo(Instruction instruction) {
        return instruction == this.trueDestination || instruction == this.falseDestination;
    }

    @Override
    public SortedSet<Instruction> createSuccessorsCache() {
        TreeSet<Instruction> successors = new TreeSet<Instruction>();
        successors.add(this.trueDestination);
        successors.add(this.falseDestination);
        return successors;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    public Instruction getTrueDestination() {
        return this.trueDestination;
    }

    public Instruction getFalseDestination() {
        return this.falseDestination;
    }

    public int getOffset() {
        return this.getTrueDestination().getByteIndex() - this.getByteIndex();
    }

    @Override
    public Instruction getTarget() {
        return this.trueDestination;
    }

    public Instruction getInstructionAfterConditionalBlock() {
        if (this.jumpsForward()) {
            Instruction before = this.getTarget().getPrevious();
            if (before instanceof GOTO) {
                return ((GOTO)before).getTarget();
            }
            return this.getTarget();
        }
        return this.getNext();
    }

    public boolean jumpsForward() {
        return this.getTarget().getIndex() > this.getIndex();
    }

    @Override
    public void resolveTargets(Instruction[] instructionsByByteIndex) {
        this.trueDestination = instructionsByByteIndex[this.getByteIndex() + this.offset];
        this.code.addIncomingBranchToInstruction(this, this.trueDestination);
        this.falseDestination = this.getNext();
        this.code.addIncomingBranchToInstruction(this, this.falseDestination);
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        if (oldTarget == this.trueDestination) {
            this.trueDestination = newTarget;
        } else if (oldTarget == this.falseDestination) {
            this.falseDestination = newTarget;
        } else {
            throw new RuntimeException("Didn't pass the old true or false target!");
        }
    }

    @Override
    public void toBytes(DataOutputStream code) throws IOException {
        code.writeByte(this.getOpcode());
        code.writeShort(this.getOffset());
    }

    public boolean isForLoop() {
        UnconditionalBranch unconditional = this.getUnconditionalBranchPrecessessor();
        return unconditional != null && this.getTarget() == unconditional.getNext();
    }

    @Override
    public EventKind getTypeProduced() {
        return null;
    }

    @Override
    protected boolean determineIfLoop() {
        return this.trueDestination.getIndex() < this.getIndex() && this.canReachInMethod(this);
    }

    @Override
    public final String getKeyword() {
        return this.isLoop() ? (this.isForLoop() ? "for" : "while") : "if";
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " ? " + this.getTrueDestination().getIndex();
    }
}

