/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.trace.Trace;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDependencyGraph {
    private final Trace trace;
    private Map<MethodInfo, Set<MethodInfo>> methodToMethods = new HashMap<MethodInfo, Set<MethodInfo>>();

    public MethodDependencyGraph(Trace trace) {
        this.trace = trace;
        List<Classfile> classes = trace.getClassfiles();
        for (Classfile c : classes) {
            for (MethodInfo m : c.getDeclaredMethods()) {
                this.analyze(m);
            }
        }
    }

    public TObjectIntHashMap<String> getMethodDistancesToMethod(MethodInfo target) {
        if (target == null) {
            System.out.println("Received null method target.");
            return null;
        }
        TObjectIntHashMap<String> distancesByMethod = new TObjectIntHashMap<String>();
        System.out.println("Analyzing distance from " + this.methodToMethods.size() + " methods to " + target.getQualifiedNameAndDescriptor());
        HashSet<MethodInfo> visited = new HashSet<MethodInfo>();
        LinkedList<MethodInfo> queue = new LinkedList<MethodInfo>();
        distancesByMethod.put(target.getQualifiedNameAndDescriptor(), 0);
        visited.add(target);
        queue.offer(target);
        while (!queue.isEmpty()) {
            MethodInfo method = (MethodInfo)queue.poll();
            assert (distancesByMethod.containsKey(method.getQualifiedNameAndDescriptor()));
            int distance = distancesByMethod.get(method.getQualifiedNameAndDescriptor()) + 1;
            for (MethodInfo relatedMethod : this.methodToMethods.get(method)) {
                if (visited.contains(relatedMethod)) continue;
                visited.add(relatedMethod);
                distancesByMethod.put(relatedMethod.getQualifiedNameAndDescriptor(), distance);
                queue.offer(relatedMethod);
            }
        }
        return distancesByMethod;
    }

    private void associate(MethodInfo one, MethodInfo two) {
        Set<MethodInfo> methods = this.methodToMethods.get(one);
        if (methods == null) {
            methods = new HashSet<MethodInfo>();
            this.methodToMethods.put(one, methods);
        }
        methods.add(two);
    }

    private void analyze(MethodInfo m) {
        CodeAttribute code = m.getCode();
        if (code == null) {
            return;
        }
        Instruction[] instructionArray = code.getInstructions();
        int n = instructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldInfo field;
            Instruction inst = instructionArray[n2];
            if (inst instanceof Invoke) {
                MethodInfo[] methodInfoArray = this.trace.getMethodsFromReference((Invoke)inst);
                int n3 = methodInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MethodInfo methodCalled = methodInfoArray[n4];
                    if (m != methodCalled) {
                        this.associate(m, methodCalled);
                        this.associate(methodCalled, m);
                    }
                    ++n4;
                }
            } else if (inst instanceof GETFIELD && (field = this.trace.resolveFieldReference(((GETFIELD)inst).getFieldref())) != null) {
                for (Definition def : field.getDefinitions()) {
                    if (def.getMethod() == m) continue;
                    this.associate(m, def.getMethod());
                    this.associate(def.getMethod(), m);
                }
            }
            ++n2;
        }
    }
}

