/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalUsesSearch
implements SearchResultsInterface {
    private final WhylineUI whylineUI;
    private final Instruction instruction;
    private final int localID;

    public LocalUsesSearch(WhylineUI whylineUI, Instruction code, int localID) {
        this.whylineUI = whylineUI;
        this.instruction = code;
        this.localID = localID;
    }

    @Override
    public String getCurrentStatus() {
        return "Done.";
    }

    @Override
    public SortedSet<Token> getResults() {
        String name = this.instruction.getCode().getLocalIDNameRelativeToInstruction(this.localID, this.instruction.getNext());
        TreeSet<Token> lines = new TreeSet<Token>();
        Instruction[] instructionArray = this.instruction.getCode().getInstructions();
        int n = instructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            String iName;
            Instruction i = instructionArray[n2];
            boolean match = false;
            if (i instanceof GetLocal && ((GetLocal)i).getLocalID() == this.localID) {
                iName = ((GetLocal)i).getLocalIDName();
                if (iName == null || iName.equals(name)) {
                    match = true;
                }
            } else if (i instanceof SetLocal && ((SetLocal)i).getLocalID() == this.localID && ((iName = ((SetLocal)i).getLocalIDName()) == null || iName.equals(name))) {
                match = true;
            }
            if (match) {
                TokenRange range = i.getFile().getTokenRangeFor(i);
                for (Token t : range) {
                    lines.add(t);
                }
            }
            ++n2;
        }
        return lines;
    }

    @Override
    public String getResultsDescription() {
        return "uses of " + this.instruction.getCode().getLocalIDNameRelativeToInstruction(this.localID, this.instruction);
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

