/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.IINC;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDependencies {
    private final CodeAttribute code;
    private final TIntObjectHashMap<TIntObjectHashMap<List<GetLocal>>> usesByInstructionIndexLocalID;
    private final TIntObjectHashMap<TIntObjectHashMap<List<SetLocal>>> definitionsByInstructionIndexLocalID;

    public LocalDependencies(CodeAttribute code) {
        this.code = code;
        this.usesByInstructionIndexLocalID = new TIntObjectHashMap();
        this.definitionsByInstructionIndexLocalID = new TIntObjectHashMap();
    }

    public List<SetLocal> getPotentialDefinitionsOfGetLocal(GetLocal instruction) {
        return this.getPotentialDefinitionsOfLocalIDBefore(instruction, instruction.getLocalID());
    }

    public List<SetLocal> getPotentialDefinitionsOfIncrement(IINC instruction) {
        return this.getPotentialDefinitionsOfLocalIDBefore(instruction, instruction.getLocalID());
    }

    public List<SetLocal> getPotentialDefinitionsOfLocalIDBefore(Instruction instruction, int localID) {
        List<SetLocal> potentialDefs;
        TIntObjectHashMap<List<SetLocal>> definitionsByInstruction = this.definitionsByInstructionIndexLocalID.get(localID);
        if (definitionsByInstruction == null) {
            definitionsByInstruction = new TIntObjectHashMap(4);
            this.definitionsByInstructionIndexLocalID.put(localID, definitionsByInstruction);
        }
        if ((potentialDefs = definitionsByInstruction.get(instruction.getIndex())) == null) {
            potentialDefs = new LinkedList<SetLocal>();
            definitionsByInstruction.put(instruction.getIndex(), potentialDefs);
            TIntHashSet visited = new TIntHashSet(64);
            Vector<Instruction> instructionsToAnalyze = new Vector<Instruction>(3);
            instructionsToAnalyze.add(instruction);
            while (!instructionsToAnalyze.isEmpty()) {
                Instruction instructionToAnalyze = (Instruction)instructionsToAnalyze.remove(instructionsToAnalyze.size() - 1);
                if (visited.contains(instructionToAnalyze.getIndex())) continue;
                visited.add(instructionToAnalyze.getIndex());
                for (Instruction predecessor : instructionToAnalyze.getOrderedPredecessors()) {
                    if (predecessor instanceof SetLocal && ((SetLocal)predecessor).getLocalID() == localID) {
                        potentialDefs.add((SetLocal)predecessor);
                        continue;
                    }
                    instructionsToAnalyze.add(predecessor);
                }
            }
        }
        return potentialDefs;
    }

    public List<GetLocal> getPotentialUsesOfArgument(int index) {
        assert (index < this.code.getMethod().getLocalIDOfFirstNonArgument()) : "local " + index + " in " + this.code.getMethod() + " isn't an argument.";
        return this.getPotentialUsesOfLocalIDAtOrAfter(this.code.getFirstInstruction(), index);
    }

    public List<GetLocal> getPotentialUsesOfLocalIDAtOrAfter(Instruction instruction, int localID) {
        List<GetLocal> potentialUses;
        TIntObjectHashMap<List<GetLocal>> usesByInstruction = this.usesByInstructionIndexLocalID.get(localID);
        if (usesByInstruction == null) {
            usesByInstruction = new TIntObjectHashMap(4);
            this.usesByInstructionIndexLocalID.put(localID, usesByInstruction);
        }
        if ((potentialUses = usesByInstruction.get(instruction.getIndex())) == null) {
            potentialUses = new LinkedList<GetLocal>();
            usesByInstruction.put(instruction.getIndex(), potentialUses);
            if (instruction instanceof GetLocal && ((GetLocal)instruction).getLocalID() == localID) {
                potentialUses.add((GetLocal)instruction);
            }
            TIntHashSet visited = new TIntHashSet(64);
            Vector<Instruction> instructionsToAnalyze = new Vector<Instruction>(3);
            instructionsToAnalyze.add(instruction);
            while (!instructionsToAnalyze.isEmpty()) {
                Instruction instructionToAnalyze = (Instruction)instructionsToAnalyze.remove(instructionsToAnalyze.size() - 1);
                if (visited.contains(instructionToAnalyze.getIndex())) continue;
                visited.add(instructionToAnalyze.getIndex());
                if (instructionToAnalyze.nextInstructionIsOnlySuccessor()) {
                    Instruction successor = instructionToAnalyze.getNext();
                    if (successor == null) continue;
                    if (successor instanceof GetLocal && ((GetLocal)successor).getLocalID() == localID) {
                        potentialUses.add((GetLocal)successor);
                    }
                    if (successor instanceof SetLocal && ((SetLocal)successor).getLocalID() == localID) continue;
                    instructionsToAnalyze.add(successor);
                    continue;
                }
                for (Instruction successor : instructionToAnalyze.getOrderedSuccessors()) {
                    if (successor instanceof GetLocal && ((GetLocal)successor).getLocalID() == localID) {
                        potentialUses.add((GetLocal)successor);
                    }
                    if (successor instanceof SetLocal && ((SetLocal)successor).getLocalID() == localID) continue;
                    instructionsToAnalyze.add(successor);
                }
            }
        }
        return potentialUses;
    }
}

