/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.io.GraphicalOutputParser;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AffectsOutputAnalyzer {
    private final Set<Instruction> dataDependenciesVisited = new HashSet<Instruction>();
    private final Set<Instruction> instructionsCheckedForInvokingOutput = new HashSet<Instruction>();
    private final Trace trace;
    private final Set<FieldInfo> fieldsPotentiallyAffectingOutput = new HashSet<FieldInfo>();
    private final Set<MethodInfo> methodsPotentiallyAffectingOutput = new HashSet<MethodInfo>();
    private final Set<MethodInfo> methodsPotentiallyInvokingOutput = new HashSet<MethodInfo>();
    private List<Instruction> graphical;
    private Collection<Instruction> textual;
    private double remainingOfCurrentPrimitive = 0.0;
    private final Util.ProgressListener listener;

    public AffectsOutputAnalyzer(Trace trace, Util.ProgressListener listener) {
        int total;
        this.trace = trace;
        this.listener = listener;
        this.graphical = trace.getGraphicalOutputInstructions();
        this.textual = trace.getTextualOutputInvokingInstructions();
        int remaining = total = this.graphical.size() + this.textual.size();
        for (Instruction primitive : this.graphical) {
            this.markDataDependenciesOf(primitive);
            if (!GraphicalOutputParser.invokesOutput(primitive)) continue;
            this.markInvokersAsInvokingOutput(primitive);
        }
        for (Instruction primitive : this.textual) {
            this.markDataDependenciesOf(primitive);
            this.markInvokersAsInvokingOutput(primitive);
        }
    }

    private QualifiedClassName getTypeOfThis(Instruction i) {
        return i.getMethod().isStatic() ? null : i.getClassfile().getInternalName();
    }

    private void markInvokersAsInvokingOutput(Instruction invoker) {
        if (this.instructionsCheckedForInvokingOutput.contains(invoker)) {
            return;
        }
        this.instructionsCheckedForInvokingOutput.add(invoker);
        MethodInfo method = invoker.getMethod();
        if (method != null) {
            this.methodsPotentiallyInvokingOutput.add(method);
            for (Invoke invoke : method.getPotentialCallers()) {
                this.markInvokersAsInvokingOutput(invoker);
            }
        }
    }

    private void markDataDependenciesOf(Instruction primitive) {
        LinkedHashSet visiting = new LinkedHashSet();
        LinkedHashSet<Instruction> toVisit = new LinkedHashSet<Instruction>();
        toVisit.add(primitive);
        while (toVisit.size() > 0) {
            this.listener.notice("Finding output affecting code (" + Util.commas(toVisit.size()) + " remaining)...");
            this.listener.progress((double)this.dataDependenciesVisited.size() / (double)this.trace.getNumberOfInstructions() / 2.0);
            LinkedHashSet temp = visiting;
            visiting = toVisit;
            toVisit = temp;
            toVisit.clear();
            for (Instruction inst : visiting) {
                if (inst == null || this.dataDependenciesVisited.contains(inst)) continue;
                this.dataDependenciesVisited.add(inst);
                if (inst instanceof GETFIELD) {
                    FieldInfo field = this.trace.resolveFieldReference(((GETFIELD)inst).getFieldref());
                    if (field != null) {
                        this.fieldsPotentiallyAffectingOutput.add(field);
                        for (Definition definition : field.getDefinitions()) {
                            toVisit.add(definition);
                        }
                    }
                } else if (inst instanceof Invoke) {
                    MethodInfo[] methodInfoArray = this.trace.getMethodsFromReference((Invoke)inst);
                    int n = methodInfoArray.length;
                    int definition = 0;
                    while (definition < n) {
                        MethodInfo method = methodInfoArray[definition];
                        this.methodsPotentiallyAffectingOutput.add(method);
                        for (AbstractReturn ret : method.getReturns()) {
                            toVisit.add(ret);
                        }
                        ++definition;
                    }
                } else if (inst instanceof GetLocal) {
                    GetLocal get = (GetLocal)inst;
                    for (SetLocal set : get.getCode().getLocalDependencies().getPotentialDefinitionsOfGetLocal(get)) {
                        toVisit.add(set);
                    }
                    if (get.getsMethodArgument()) {
                        int argumentNumber = get.getMethod().getArgumentNumberOfLocalID(get.getLocalID());
                        for (Invoke potentialCaller : get.getMethod().getPotentialCallers()) {
                            StackDependencies.Producers producers = potentialCaller.getProducersOfArgument(argumentNumber);
                            int i = 0;
                            while (i < producers.getNumberOfProducers()) {
                                toVisit.add(producers.getProducer(i));
                                ++i;
                            }
                        }
                    }
                }
                for (Instruction branch : inst.getBranchDependencies()) {
                    toVisit.add(branch);
                }
                int arg = 0;
                while (arg < inst.getNumberOfArgumentProducers()) {
                    StackDependencies.Producers producers = inst.getProducersOfArgument(arg);
                    int i = 0;
                    while (i < producers.getNumberOfProducers()) {
                        toVisit.add(producers.getProducer(i));
                        ++i;
                    }
                    ++arg;
                }
            }
        }
    }

    public Set<FieldInfo> getFieldsAffectingOutput() {
        return this.fieldsPotentiallyAffectingOutput;
    }

    public Set<MethodInfo> getMethodsAffectingOutput() {
        return this.methodsPotentiallyAffectingOutput;
    }

    public Set<MethodInfo> getMethodsInvokingOutput() {
        return this.methodsPotentiallyInvokingOutput;
    }
}

