/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline;

import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.launcher.LauncherUI;
import edu.cmu.hcii.whyline.ui.launcher.MacLauncherUI;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public final class Whyline {
    public static final int WHYLINE_FAILURE_EXIT_CODE = 711;
    private static final String JDK_SOURCE_PATH = "JDK_SOURCE_PATH";
    private static final String WHYLINE_HOME_PATH_KEY = "whylineHomePath";
    private static String WHYLINE_HOME;
    private static File WHYLINE_FOLDER;
    public static final String IDS_NAME = "ids";
    public static final String CALLS_NAME = "calls";
    public static final String VALUES_NAME = "values";
    public static final String CLASSIDS_NAME = "classids";
    public static final String TRACE_FILE_SUFFIX = ".history";
    public static final String STATIC_FOLDER_PATH = "static";
    public static final String DYNAMIC_FOLDER_PATH = "dynamic";
    public static final String META_PATH = "meta";
    public static final String USAGE_PATH = "usage.log";
    public static final String IMMUTABLES_PATH;
    public static final String OBJECT_TYPES_PATH;
    public static final String HISTORY_PATH;
    public static final String RANDOM_PATH;
    public static final String SERIAL_PATH;
    public static final String IDS_PATH;
    public static final String CALLS_PATH;
    public static final String VALUES_PATH;
    public static final String RANGES_PATH;
    public static final String IO_PATH;
    public static final String EXCEPTIONS_PATH;
    public static final String STATIC_ASSIGNMENTS_PATH;
    public static final String FIELD_ASSIGNMENTS_PATH;
    public static final String ARRAY_ASSIGNMENTS_PATH;
    public static final String INSTANTIATIONS_PATH;
    public static final String INITIALIZATIONS_PATH;
    public static final String RUNS_PATH;
    public static final String INVOCATIONS_PATH;
    public static final String ARGUMENTS_PATH;
    public static final String IMAGE_PATH;
    public static final String KEY_PATH;
    public static final String MOUSE_PATH;
    public static final String REPAINT_PATH;
    public static final String CREATE_PATH;
    public static final String SOURCE_PATH;
    public static final String CLASSNAMES_PATH;
    public static final String CLASSES_PATH;
    public static final String CLASSIDS_PATH;
    public static final String CALL_GRAPH_PATH;
    public static final String OUTPUT_PATH;
    public static final String CLASS_CACHE_PATH = "classes";
    public static final String ANALYZED_CLASS_CACHE_FOLDER_NAME = "uninstrumented";
    public static final String INSTRUMENTED_CLASS_CACHE_FOLDER_NAME = "instrumented";
    public static final String EXECUTIONS_FILE_NAME = "configurations.xml";
    public static final String SAVED_TRACES_FOLDER_NAME = "saved";
    public static final String WORKING_TRACE_FOLDER_NAME = "recent";
    private static File WORKING_TRACE_FOLDER;
    private static File WORKING_CLASSIDS_FILE;
    private static File WORKING_IMMUTABLES_FILE;
    private static File WORKING_CLASSNAMES_FILE;
    private static File WORKING_META_FILE;
    private static File WORKING_OBJECT_TYPES_FILE;
    private static File WORKING_SERIAL_HISTORY_FOLDER;
    private static File WORKING_SOURCE_FOLDER;
    private static File CLASS_CACHE_FOLDER;
    private static File UNINSTRUMENTED_CLASS_CACHE_FOLDER;
    private static File INSTRUMENTED_CLASS_CACHE_FOLDER;
    private static File SAVED_TRACES_FOLDER;
    public static File WHYLINE_JAR_PATH;

    static {
        IMMUTABLES_PATH = DYNAMIC_FOLDER_PATH + File.separatorChar + "immutables";
        OBJECT_TYPES_PATH = DYNAMIC_FOLDER_PATH + File.separatorChar + "objects";
        HISTORY_PATH = DYNAMIC_FOLDER_PATH + File.separatorChar + "history";
        RANDOM_PATH = String.valueOf(HISTORY_PATH) + File.separatorChar + "random";
        SERIAL_PATH = String.valueOf(HISTORY_PATH) + File.separatorChar + "serial";
        IDS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + IDS_NAME;
        CALLS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + CALLS_NAME;
        VALUES_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + VALUES_NAME;
        RANGES_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "ranges";
        IO_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "io";
        EXCEPTIONS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "exceptions";
        STATIC_ASSIGNMENTS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "globals";
        FIELD_ASSIGNMENTS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "fields";
        ARRAY_ASSIGNMENTS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "arrays";
        INSTANTIATIONS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "instantiations";
        INITIALIZATIONS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "initializations";
        RUNS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "runs";
        INVOCATIONS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "invocations";
        ARGUMENTS_PATH = String.valueOf(RANDOM_PATH) + File.separatorChar + "arguments";
        IMAGE_PATH = String.valueOf(ARGUMENTS_PATH) + File.separatorChar + "image";
        KEY_PATH = String.valueOf(ARGUMENTS_PATH) + File.separatorChar + "key";
        MOUSE_PATH = String.valueOf(ARGUMENTS_PATH) + File.separatorChar + "mouse";
        REPAINT_PATH = String.valueOf(ARGUMENTS_PATH) + File.separatorChar + "repaint";
        CREATE_PATH = String.valueOf(ARGUMENTS_PATH) + File.separatorChar + "create";
        SOURCE_PATH = STATIC_FOLDER_PATH + File.separatorChar + "source";
        CLASSNAMES_PATH = STATIC_FOLDER_PATH + File.separatorChar + "classnames";
        CLASSES_PATH = STATIC_FOLDER_PATH + File.separatorChar + CLASS_CACHE_PATH;
        CLASSIDS_PATH = STATIC_FOLDER_PATH + File.separatorChar + CLASSIDS_NAME;
        CALL_GRAPH_PATH = STATIC_FOLDER_PATH + File.separatorChar + "callgraph";
        OUTPUT_PATH = STATIC_FOLDER_PATH + File.separatorChar + "output";
        WHYLINE_JAR_PATH = null;
        try {
            Whyline.initializeSystemProperties();
            String home = Whyline.loadPreferences();
            Whyline.setHome(new File(home));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void main(String[] args) throws Exception {
        if (args.length == 0) {
            WHYLINE_JAR_PATH = new File(System.getProperty("user.dir"), "whyline.jar");
            if (!WHYLINE_JAR_PATH.exists()) {
                JOptionPane.showMessageDialog(null, "<html>Couldn't find \"whyline.jar\" at \n\n" + WHYLINE_JAR_PATH, "Problem", 0);
                System.exit(0);
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                new MacLauncherUI();
            } else {
                new LauncherUI();
            }
        } else {
            File trace;
            if (args.length > 1) {
                Whyline.debug("Ignoring extra arguments...");
            }
            if (!(trace = new File(args[0])).exists()) {
                JOptionPane.showMessageDialog(null, "<html>Couldn't find a trace at " + trace, "Problem", 0);
                System.exit(0);
            }
            Whyline.debug("Loading trace at \"" + trace.getPath());
            new WhylineUI(null, trace, WhylineUI.Mode.WHYLINE);
        }
    }

    private static void initializeSystemProperties() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        System.setProperty("swing.defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel");
        System.setProperty("swing.aatext", "true");
        System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        System.setProperty("awt.useSystemAAFontSettings", "true");
        UI.class.getName();
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(Whyline.class);
    }

    private static String loadPreferences() {
        UI.class.getName();
        Preferences userPrefs = Whyline.getPreferences();
        String WHYLINE_HOME = userPrefs.get(WHYLINE_HOME_PATH_KEY, String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "whyline" + File.separatorChar);
        userPrefs.put(WHYLINE_HOME_PATH_KEY, WHYLINE_HOME);
        try {
            userPrefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return WHYLINE_HOME;
    }

    public static String getJDKJavaDocPath() {
        return Whyline.getPreferences().get("JDK_JAVADOC_PATH", "http://java.sun.com/j2se/1.5.0/docs/api/");
    }

    public static void setJDKSourcePath(String sourcePath) {
        Preferences userPrefs = Whyline.getPreferences();
        userPrefs.put(JDK_SOURCE_PATH, sourcePath);
        try {
            userPrefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static String getJDKSourcePath() {
        Preferences userPrefs = Whyline.getPreferences();
        String sourcePath = userPrefs.get(JDK_SOURCE_PATH, null);
        if (sourcePath == null) {
            String OSXPathToSource = "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home/src.jar";
            String WindowsPathToSource = "C:/jdk1.5.0/src.zip";
            String osName = System.getProperty("os.name");
            if (osName.contains("OS X")) {
                sourcePath = OSXPathToSource;
            } else if (osName.contains("Windows")) {
                sourcePath = WindowsPathToSource;
            }
            userPrefs.put(JDK_SOURCE_PATH, sourcePath);
            try {
                userPrefs.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return sourcePath;
    }

    public static void setHome(File home) {
        Preferences userPrefs = Whyline.getPreferences();
        userPrefs.put(WHYLINE_HOME_PATH_KEY, home.getAbsolutePath());
        try {
            userPrefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        WHYLINE_FOLDER = home;
        WHYLINE_FOLDER.mkdir();
        WORKING_TRACE_FOLDER = new File(WHYLINE_FOLDER, WORKING_TRACE_FOLDER_NAME);
        WORKING_CLASSIDS_FILE = new File(WHYLINE_FOLDER, CLASSIDS_NAME);
        WORKING_IMMUTABLES_FILE = new File(WORKING_TRACE_FOLDER, IMMUTABLES_PATH);
        WORKING_META_FILE = new File(WORKING_TRACE_FOLDER, META_PATH);
        WORKING_OBJECT_TYPES_FILE = new File(WORKING_TRACE_FOLDER, OBJECT_TYPES_PATH);
        WORKING_SERIAL_HISTORY_FOLDER = new File(WORKING_TRACE_FOLDER, SERIAL_PATH);
        WORKING_SOURCE_FOLDER = new File(WORKING_TRACE_FOLDER, SOURCE_PATH);
        WORKING_CLASSNAMES_FILE = new File(WORKING_TRACE_FOLDER, CLASSNAMES_PATH);
        CLASS_CACHE_FOLDER = new File(WHYLINE_FOLDER, CLASS_CACHE_PATH);
        UNINSTRUMENTED_CLASS_CACHE_FOLDER = new File(Whyline.getClassCacheFolder(), ANALYZED_CLASS_CACHE_FOLDER_NAME);
        INSTRUMENTED_CLASS_CACHE_FOLDER = new File(Whyline.getClassCacheFolder(), INSTRUMENTED_CLASS_CACHE_FOLDER_NAME);
        SAVED_TRACES_FOLDER = new File(WHYLINE_FOLDER, SAVED_TRACES_FOLDER_NAME);
    }

    public static File getHome() {
        return WHYLINE_FOLDER;
    }

    public static File getWorkingTraceFolder() {
        return WORKING_TRACE_FOLDER;
    }

    public static File getWorkingClassIDsFile() {
        return WORKING_CLASSIDS_FILE;
    }

    public static File getWorkingImmutablesFile() {
        return WORKING_IMMUTABLES_FILE;
    }

    public static File getWorkingClassnamesFile() {
        return WORKING_CLASSNAMES_FILE;
    }

    public static File getWorkingMetaFile() {
        return WORKING_META_FILE;
    }

    public static File getWorkingObjectTypesFile() {
        return WORKING_OBJECT_TYPES_FILE;
    }

    public static File getWorkingSerialHistoryFolder() {
        return WORKING_SERIAL_HISTORY_FOLDER;
    }

    public static File getWorkingSourceFolder() {
        return WORKING_SOURCE_FOLDER;
    }

    public static File getClassCacheFolder() {
        return CLASS_CACHE_FOLDER;
    }

    public static File getUninstrumentedClassCacheFolder() {
        return UNINSTRUMENTED_CLASS_CACHE_FOLDER;
    }

    public static File getInstrumentedClassCacheFolder() {
        return INSTRUMENTED_CLASS_CACHE_FOLDER;
    }

    public static File getSavedTracesFolder() {
        return SAVED_TRACES_FOLDER;
    }

    public static final void debug(String message) {
        System.out.println("whyline >\t" + message);
    }

    public static final void debugBreak() {
        Whyline.debug("");
        System.out.println("whyline >\t>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        Whyline.debug("");
    }
}

