/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.util;

import edu.cmu.hcii.whyline.util.IntegerVector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IntegerRange {
    private final IntegerVector ranges;

    public IntegerRange(int initialCapacity) {
        this.ranges = new IntegerVector(initialCapacity);
    }

    public void include(int number) {
        if (this.ranges.size() > 0 && this.ranges.lastValue() > number) {
            throw new RuntimeException("Range numbers must be added in order. The most recent value was " + this.ranges.lastValue() + " but the next number given was " + number);
        }
        if (this.ranges.isEmpty() || number != this.ranges.lastValue() + 1) {
            this.ranges.append(number);
            this.ranges.append(number);
        } else {
            this.ranges.set(number, this.ranges.size() - 1);
        }
    }

    public boolean contains(int number) {
        return this.getRangeIndexContaining(number) != -1;
    }

    public int getFirst() {
        return this.ranges.get(0);
    }

    public int getLast() {
        return this.ranges.lastValue();
    }

    public int getRangeIndexContaining(int number) {
        int index = this.getRangeIndexWithValueLessThanOrEqualTo(number);
        int lower = this.getLowerBoundOfRange(index);
        int upper = this.getUpperBoundOfRange(index);
        if (lower <= number && number <= upper) {
            return index;
        }
        return -1;
    }

    public int getRangeIndexWithValueLessThanOrEqualTo(int number) {
        int index = this.ranges.getIndexOfLargestValueLessThanOrEqualTo(number);
        if (index < 0) {
            return index;
        }
        index -= index % 2;
        return index /= 2;
    }

    public int getLowerBoundOfRange(int range) {
        return this.ranges.get(range * 2);
    }

    public int getUpperBoundOfRange(int range) {
        return this.ranges.get(range * 2 + 1);
    }

    public boolean hasRange(int range) {
        return range >= 0 && range * 2 + 1 < this.ranges.size();
    }

    public void write(DataOutputStream out) throws IOException {
        this.ranges.write(out);
    }

    public void read(DataInputStream in) throws IOException {
        this.ranges.read(in);
    }

    public void trimToSize() {
        this.ranges.trimToSize();
    }

    public String toString() {
        if (this.ranges.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.ranges.size()) {
            builder.append("[ ");
            builder.append(this.ranges.get(i));
            builder.append(" - ");
            builder.append(this.ranges.get(i + 1));
            builder.append(" ]\n");
            i += 2;
        }
        return builder.toString();
    }
}

