/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class UnexecutedInstructionView
extends View {
    private final Visualization visualization;
    private final UnexecutedInstruction instructionNotExecuted;
    private int row;
    private int column;
    public boolean selectedOrPointedToFromSelection = false;
    private final float STROKE_WIDTH = 2.0f;
    public static final int ICON_SIZE = 50;
    public static final int STANDARD_WIDTH = 150;
    public static int LABEL_HEIGHT = 0;
    public static GlyphVector CHECKMARK;
    public static GlyphVector XMARK;
    public static GlyphVector PARENS;
    public static GlyphVector NO;
    public static GlyphVector CALLERS;
    public static GlyphVector IF;
    public static Rectangle2D CHECKMARK_BOUNDS;
    public static Rectangle2D XMARK_BOUNDS;
    public static Rectangle2D PARENS_BOUNDS;
    public static Rectangle2D NO_BOUNDS;
    public static Rectangle2D CALLERS_BOUNDS;
    public static Rectangle2D IF_BOUNDS;
    public static int VISIBLE_GLYPH_HEIGHT;
    public static int GLYPH_ASCENT;
    private final Stroke unselectedStroke = new BasicStroke(2.0f, 2, 2);
    private final Stroke selectedStroke = new BasicStroke(8.0f, 2, 2);
    private GlyphVector classnameGlyphs;
    private GlyphVector subjectGlyphs;
    private GlyphVector eventGlyphs;
    private Rectangle2D classnameBounds;
    private Rectangle2D subjectBounds;
    private Rectangle2D eventBounds;
    private static final AlphaComposite transparent;
    private static final AlphaComposite opaque;

    static {
        transparent = AlphaComposite.getInstance(3, 0.3f);
        opaque = AlphaComposite.getInstance(3, 1.0f);
    }

    public UnexecutedInstructionView(Visualization viz, UnexecutedInstruction i) {
        this.visualization = viz;
        this.instructionNotExecuted = i;
        this.update();
    }

    public void setGridLocation(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public void update() {
        String eventLabel;
        String subjectLabel;
        if (LABEL_HEIGHT == 0) {
            Graphics2D g = (Graphics2D)this.visualization.getWhylineUI().getGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            LABEL_HEIGHT = g.getFontMetrics(UI.getSmallFont()).getHeight() * 3;
            Font full = UI.getSmallFont().deriveFont(36.0f);
            Font half = UI.getSmallFont().deriveFont(12.0f);
            NO = half.createGlyphVector(g.getFontRenderContext(), "NO");
            NO_BOUNDS = NO.getLogicalBounds();
            CALLERS = half.createGlyphVector(g.getFontRenderContext(), "CALLERS");
            CALLERS_BOUNDS = CALLERS.getLogicalBounds();
            IF = full.createGlyphVector(g.getFontRenderContext(), "if");
            IF_BOUNDS = IF.getLogicalBounds();
            CHECKMARK = full.createGlyphVector(g.getFontRenderContext(), String.valueOf('\u2713'));
            CHECKMARK_BOUNDS = CHECKMARK.getLogicalBounds();
            XMARK = full.createGlyphVector(g.getFontRenderContext(), String.valueOf('\u2716'));
            XMARK_BOUNDS = XMARK.getLogicalBounds();
            PARENS = full.createGlyphVector(g.getFontRenderContext(), "()");
            PARENS_BOUNDS = PARENS.getLogicalBounds();
            VISIBLE_GLYPH_HEIGHT = (int)PARENS.getVisualBounds().getHeight();
            GLYPH_ASCENT = g.getFontMetrics(full).getAscent();
        }
        Instruction instruction = this.instructionNotExecuted.getInstruction();
        String classnameLabel = Util.elide(instruction.getClassfile().getSimpleName(), 16);
        String lineLabel = "line " + instruction.getLineNumber().getNumber();
        String truncatedMethodName = String.valueOf(Util.elide(instruction.getMethod().getJavaName(), 10)) + "()";
        UnexecutedInstruction.Reason reason = this.instructionNotExecuted.getReason();
        switch (reason) {
            case DID_EXECUTE: {
                subjectLabel = truncatedMethodName;
                eventLabel = "did execute";
                break;
            }
            case INSTRUCTIONS_BRANCH_DID_NOT_EXECUTE: {
                subjectLabel = String.valueOf(lineLabel) + "'s";
                eventLabel = String.valueOf(this.instructionNotExecuted.getDecidingInstructions().size() > 1 ? "conditionals" : "conditional") + " didn't execute";
                break;
            }
            case UNREACHABLE: {
                subjectLabel = String.valueOf(lineLabel) + " didn't execute";
                eventLabel = String.valueOf(truncatedMethodName) + " has no known callers";
                break;
            }
            case WRONG_WAY: {
                subjectLabel = String.valueOf(lineLabel) + "'s";
                eventLabel = "conditional went wrong way";
                break;
            }
            case METHOD_DID_NOT_EXECUTE: {
                subjectLabel = String.valueOf(lineLabel) + " didn't execute";
                eventLabel = String.valueOf(truncatedMethodName) + " wasn't called";
                break;
            }
            case EXCEPTION_CAUGHT: {
                subjectLabel = truncatedMethodName;
                eventLabel = "exception thrown";
                break;
            }
            default: {
                subjectLabel = "line " + instruction.getLineNumber().getNumber() + " didn't execute";
                eventLabel = "unknown reason";
            }
        }
        Graphics2D g = (Graphics2D)this.visualization.getWhylineUI().getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext context = g.getFontRenderContext();
        this.classnameGlyphs = UI.getSmallFont().deriveFont(2).createGlyphVector(context, classnameLabel);
        this.subjectGlyphs = UI.getSmallFont().deriveFont(1).createGlyphVector(context, subjectLabel);
        this.eventGlyphs = UI.getSmallFont().createGlyphVector(context, eventLabel);
        this.classnameBounds = this.classnameGlyphs.getLogicalBounds();
        this.subjectBounds = this.subjectGlyphs.getLogicalBounds();
        this.eventBounds = this.eventGlyphs.getLogicalBounds();
        this.setLocalWidth(75.0, false);
        this.setLocalHeight(XMARK_BOUNDS.getHeight() + (double)LABEL_HEIGHT, false);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public UnexecutedInstruction getUnexecutedInstruction() {
        return this.instructionNotExecuted;
    }

    public Instruction getInstruction() {
        return this.instructionNotExecuted.getInstruction();
    }

    public boolean handleMouseDown(int localX, int localY, int mouseButton) {
        this.visualization.getVisualizationUI().setSelection(this, false, "click");
        return true;
    }

    public void paintBelowChildren(Graphics2D g) {
        Point2D to;
        Point2D from;
        View view;
        boolean selected;
        g = (Graphics2D)g.create();
        boolean bl = selected = this.visualization.getSelectedUnexecutedInstructionView() == this;
        if (this.instructionNotExecuted.getReason() == UnexecutedInstruction.Reason.WRONG_WAY) {
            IntegerVector events = null;
            if (this.instructionNotExecuted.getDecidingEventID() >= 0) {
                events = new IntegerVector(1);
                events.append(this.instructionNotExecuted.getDecidingEventID());
            } else if (this.instructionNotExecuted.getDecidingEvents() != null) {
                events = this.instructionNotExecuted.getDecidingEvents();
            }
            if (events != null) {
                int i = 0;
                while (i < events.size()) {
                    view = this.visualization.getViewOfEvent(events.get(i));
                    if (view != null) {
                        from = this.localToLocal(view, new Point2D.Double(view.getLocalRight(), view.getLocalTop() + view.getLocalHeight() / 2.0));
                        g.setColor(UI.CONTROL_COLOR);
                        to = Util.getIntersectionOfSegmentAndBox(this.getLocalHorizontalCenter(), this.getLocalTop() + 25.0, this.getLocalLeft(), this.getLocalTop(), this.getLocalRight(), this.getLocalTop() + 50.0, from.getX(), from.getY());
                        Util.drawQuadraticCurveArrow(g, (int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY(), -10, -10, true, UI.UNSELECTED_STROKE);
                    } else {
                        System.err.println("Couldn't find view of event ID " + events.get(i));
                    }
                    ++i;
                }
            }
        }
        if (selected) {
            g.setColor(UI.ERROR_COLOR);
            g.setStroke(UI.UNSELECTED_STROKE);
            for (UnexecutedInstruction in : this.instructionNotExecuted.getIncoming()) {
                view = this.visualization.getUnexecutedInstructionView(in);
                if (view == null || view == this) continue;
                from = this.localToLocal(view, new Point2D.Double(view.getLocalHorizontalCenter(), view.getLocalVerticalCenter()));
                from = Util.getIntersectionOfSegmentAndBox(from.getX(), from.getY() - view.getLocalHeight() / 2.0 + 25.0, from.getX() - view.getLocalWidth() / 2.0, from.getY() - view.getLocalHeight() / 2.0, from.getX() + view.getLocalWidth() / 2.0, from.getY() + 25.0, this.getLocalHorizontalCenter(), this.getLocalVerticalCenter());
                to = Util.getIntersectionOfSegmentAndBox(this.getLocalHorizontalCenter(), this.getLocalTop() + 25.0, this.getLocalLeft(), this.getLocalTop(), this.getLocalRight(), this.getLocalTop() + 50.0, from.getX(), from.getY());
                Util.drawQuadraticCurveArrow(g, (int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY(), -10, -10, true, UI.SELECTED_STROKE);
            }
            g.setComposite(transparent);
            for (UnexecutedInstruction out : this.instructionNotExecuted.getOutgoing()) {
                view = this.visualization.getUnexecutedInstructionView(out);
                if (view == null || view == this) continue;
                Point2D to2 = this.localToLocal(view, new Point2D.Double(view.getLocalHorizontalCenter(), view.getLocalVerticalCenter()));
                to2 = Util.getIntersectionOfSegmentAndBox(to2.getX(), to2.getY() - view.getLocalHeight() / 2.0 + 25.0, to2.getX() - view.getLocalWidth() / 2.0, to2.getY() - view.getLocalHeight() / 2.0, to2.getX() + view.getLocalWidth() / 2.0, to2.getY() + 25.0, this.getLocalHorizontalCenter(), this.getLocalVerticalCenter());
                Point2D from2 = Util.getIntersectionOfSegmentAndBox(this.getLocalHorizontalCenter(), this.getLocalTop() + 25.0, this.getLocalLeft(), this.getLocalTop(), this.getLocalRight(), this.getLocalTop() + 50.0, to2.getX(), to2.getY());
                Util.drawQuadraticCurveArrow(g, (int)from2.getX(), (int)from2.getY(), (int)to2.getX(), (int)to2.getY(), -10, -10, true, UI.UNSELECTED_STROKE);
            }
        }
        int middle = (int)(this.getVisibleLocalLeft() + this.getVisibleLocalWidth() / 2.0);
        double heightOfLabels = this.eventBounds.getHeight() + this.subjectBounds.getHeight() + this.classnameBounds.getHeight();
        int x1 = (int)((float)(middle - 25) + 2.0f);
        int x2 = (int)((float)(middle + 25) - 2.0f);
        int y1 = (int)this.getVisibleLocalTop();
        int y2 = (int)(this.getVisibleLocalTop() + 50.0);
        int width = (int)this.getVisibleLocalWidth();
        if (selected) {
            g.setComposite(opaque);
            g.setStroke(UI.SELECTED_STROKE);
            g.setColor(UI.getHighlightColor());
            g.drawRoundRect((int)this.getVisibleLocalLeft(), (int)this.getVisibleLocalTop(), (int)this.getVisibleLocalWidth(), 50, UI.getRoundedness(), UI.getRoundedness());
            g.setStroke(UI.UNSELECTED_STROKE);
        } else {
            g.setComposite(transparent);
        }
        switch (this.instructionNotExecuted.getReason()) {
            case DID_EXECUTE: {
                g.setColor(UI.CORRECT_COLOR);
                g.drawGlyphVector(CHECKMARK, this.getCenterXOf(CHECKMARK_BOUNDS), y2);
                break;
            }
            case INSTRUCTIONS_BRANCH_DID_NOT_EXECUTE: {
                g.setColor(UI.getControlTextColor());
                g.drawGlyphVector(IF, (int)this.getLocalHorizontalCenter(), this.getCenterYOf(IF_BOUNDS));
                g.setColor(Color.red);
                g.drawGlyphVector(XMARK, (int)(this.getLocalHorizontalCenter() - XMARK_BOUNDS.getWidth()), this.getCenterYOf(XMARK_BOUNDS));
                break;
            }
            case UNREACHABLE: {
                int lineHeight = (int)NO_BOUNDS.getHeight();
                g.setColor(Color.red);
                g.drawGlyphVector(NO, this.getCenterXOf(NO_BOUNDS), this.getCenterYOf(NO_BOUNDS) - lineHeight);
                g.drawGlyphVector(CALLERS, this.getCenterXOf(CALLERS_BOUNDS), this.getCenterYOf(NO_BOUNDS));
                break;
            }
            case METHOD_DID_NOT_EXECUTE: {
                g.setColor(UI.getControlTextColor());
                g.drawGlyphVector(PARENS, (int)this.getLocalHorizontalCenter(), this.getCenterYOf(PARENS_BOUNDS));
                g.setColor(Color.red);
                g.drawGlyphVector(XMARK, (int)(this.getLocalHorizontalCenter() - XMARK_BOUNDS.getWidth()), this.getCenterYOf(XMARK_BOUNDS));
                break;
            }
            case WRONG_WAY: {
                g.setColor(UI.getControlTextColor());
                g.drawGlyphVector(IF, this.getCenterXOf(IF_BOUNDS), this.getCenterYOf(IF_BOUNDS));
                g.setColor(Color.red);
                g.drawGlyphVector(XMARK, this.getCenterXOf(XMARK_BOUNDS) + (int)IF_BOUNDS.getWidth(), this.getCenterYOf(XMARK_BOUNDS));
                g.setColor(Color.green);
                g.drawGlyphVector(CHECKMARK, this.getCenterXOf(CHECKMARK_BOUNDS) - (int)IF_BOUNDS.getWidth(), this.getCenterYOf(CHECKMARK_BOUNDS));
                break;
            }
            case EXCEPTION_CAUGHT: {
                g.setColor(Color.red);
                g.drawGlyphVector(XMARK, (int)(this.getLocalHorizontalCenter() - XMARK_BOUNDS.getWidth() / 2.0), this.getCenterYOf(XMARK_BOUNDS));
            }
        }
        int labelX = (int)(this.getVisibleLocalLeft() + (this.getVisibleLocalWidth() - this.subjectBounds.getWidth()) / 2.0);
        int labelY = (int)(this.getVisibleLocalTop() + 50.0 + this.subjectBounds.getHeight() + 5.0);
        int classnameX = (int)(this.getVisibleLocalLeft() + (this.getVisibleLocalWidth() - this.classnameBounds.getWidth()) / 2.0);
        int lineX = (int)(this.getVisibleLocalLeft() + (this.getVisibleLocalWidth() - this.eventBounds.getWidth()) / 2.0);
        g.setColor(UI.getControlTextColor());
        g.drawGlyphVector(this.classnameGlyphs, classnameX, labelY);
        g.drawGlyphVector(this.subjectGlyphs, labelX, labelY + (int)this.subjectBounds.getHeight());
        g.drawGlyphVector(this.eventGlyphs, lineX, labelY + (int)this.subjectBounds.getHeight() + (int)this.eventBounds.getHeight());
    }

    private int getCenterXOf(Rectangle2D glyphBounds) {
        return (int)(this.getVisibleLocalLeft() + (this.getVisibleLocalWidth() - glyphBounds.getWidth()) / 2.0);
    }

    private int getCenterYOf(Rectangle2D glyphBounds) {
        return (int)(this.getVisibleLocalTop() + 50.0 - (double)((50 - VISIBLE_GLYPH_HEIGHT) / 2));
    }

    private int getXOnTheRight() {
        return (int)(this.getVisibleLocalRight() - this.getVisibleLocalWidth() / 2.0 + PARENS_BOUNDS.getWidth() / 2.0);
    }

    private int getYOnTheRight() {
        return (int)(this.getVisibleLocalTop() + 25.0);
    }

    private int getXOnTheLeft() {
        return (int)(this.getVisibleLocalLeft() + this.getVisibleLocalWidth() / 4.0 - 8.0);
    }

    private int getYOnTheLeft() {
        return (int)((double)this.getCenterYOf(XMARK_BOUNDS) - XMARK_BOUNDS.getHeight() / 4.0);
    }
}

