/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.qa;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.qa.InvocationBlock;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.qa.ArgumentEventView;
import edu.cmu.hcii.whyline.ui.qa.EventBlockView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Color;
import java.awt.Graphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationBlockView
extends EventBlockView<InvocationBlock> {
    public InvocationBlockView(Visualization visualization, InvocationBlock block) {
        super(visualization, block);
    }

    @Override
    protected boolean isFamiliarInitially() {
        MethodrefInfo methodref = ((Invoke)this.visualization.getTrace().getInstruction(((InvocationBlock)this.getBlock()).getEventID())).getMethodInvoked();
        Trace trace = this.visualization.getTrace();
        Classfile classfile = trace.getClassfileByName(methodref.getClassName());
        boolean methodSourceIsFamiliar = classfile != null && trace.hasUserSourceFileFor(classfile);
        return methodSourceIsFamiliar;
    }

    public static final void paintParensAndBraces(EventBlockView<?> view, Visualization visualization, Graphics2D g) {
        int leftParenX = (int)(view.getLocalLeft() + 8.0 + view.widthOfLabel);
        int parenY = (int)(view.getLocalBottom() - (view.getLocalHeight() - visualization.PAREN_ASCENT) / 2.0 - visualization.PAREN_DESCENT);
        View lastVisibleArgument = null;
        for (View child : view.getChildren()) {
            if (!(child instanceof ArgumentEventView) || ((ArgumentEventView)child).isHidden()) continue;
            lastVisibleArgument = (ArgumentEventView)child;
        }
        int rightParenX = lastVisibleArgument == null ? leftParenX + (int)visualization.PAREN_WIDTH : (int)(view.getLocalLeft() + lastVisibleArgument.getLocalRight() + 4.0);
        g.setFont(UI.getSmallFont());
        g.setColor(UI.getControlTextColor());
        g.drawGlyphVector(visualization.LEFT_PAREN, leftParenX, parenY);
        g.drawGlyphVector(visualization.RIGHT_PAREN, rightParenX, parenY);
        g.drawGlyphVector(visualization.CLOSING_BRACE, (float)view.getVisibleLocalRight() + 4.0f, parenY);
    }

    @Override
    protected double getPaddingAfterLabel() {
        boolean hasVisibleArgument = false;
        for (View child : this.getChildren()) {
            if (!(child instanceof ArgumentEventView)) break;
            if (((ArgumentEventView)child).isHidden()) continue;
            hasVisibleArgument = true;
            break;
        }
        return hasVisibleArgument ? 0.0 : this.visualization.PAREN_WIDTH + this.visualization.PAREN_AND_BRACE_WIDTH;
    }

    @Override
    protected final void paintExpanded(Graphics2D g) {
        super.paintExpanded(g);
        InvocationBlockView.paintParensAndBraces(this, this.visualization, g);
    }

    @Override
    public String determineFirstLine() {
        Invoke invoke = (Invoke)this.visualization.getTrace().getInstruction(this.getEventID());
        String methodName = invoke.getJavaMethodName();
        String full = String.valueOf(methodName) + (this.isCollapsed() ? "()" : "");
        return Util.elide(full, 12);
    }

    @Override
    public String determineSecondLine() {
        return null;
    }

    @Override
    protected Color determineBorderColor() {
        return ((InvocationBlock)this.getBlock()).invocationWasInstrumented() ? UI.CONTROL_COLOR : UI.UNFAMILIAR_COLOR;
    }
}

