/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.components;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.Vector;

public class SimpleHTML {
    private Vector<String> tokens;
    private Vector<Span> spans;
    private final Graphics2D context;
    private final Font font;
    private int width;
    private int height;

    public SimpleHTML(String html, Graphics2D context, Font font) {
        this.context = (Graphics2D)context.create();
        this.context.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.font = font;
        this.tokenize(html);
        this.parse();
    }

    private void tokenize(String html) {
        this.tokens = new Vector();
        StringBuffer buffer = new StringBuffer();
        char[] characters = html.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char c = characters[i];
            if (c == '<') {
                int open = i++;
                while (i < characters.length && characters[i] != '>') {
                    ++i;
                }
                buffer.append(characters, open, i - open + 1);
                ++i;
                this.tokens.add(buffer.toString());
                buffer.delete(0, buffer.length());
                continue;
            }
            int first = i;
            while (i < characters.length && characters[i] != '<') {
                ++i;
            }
            buffer.append(characters, first, i - first);
            this.tokens.add(buffer.toString());
            buffer.delete(0, buffer.length());
        }
    }

    private void parse() {
        this.spans = new Vector();
        int left = 0;
        FontMetrics metrics = this.context.getFontMetrics(this.font);
        int baseline = metrics.getAscent();
        int i = 0;
        while (i < this.tokens.size()) {
            String token = this.tokens.get(i);
            if (token.startsWith("<")) {
                if (i + 1 >= this.tokens.size()) {
                    System.err.println("Invalid index! " + this.tokens);
                }
                String middle = this.tokens.get(i + 1);
                middle = this.translateText(middle);
                if (token.equals("<b>")) {
                    this.spans.add(new Span(middle, this.font.deriveFont(1), this.context.getFontRenderContext(), left, baseline));
                } else if (token.equals("<i>") || token.equals("<em>")) {
                    this.spans.add(new Span(middle, this.font.deriveFont(2), this.context.getFontRenderContext(), left, baseline));
                } else if (token.equals("<font>")) {
                    this.spans.add(new Span(middle, this.font, this.context.getFontRenderContext(), left, baseline));
                } else {
                    this.spans.add(new Span(middle, this.font, this.context.getFontRenderContext(), left, baseline));
                }
                ++i;
                ++i;
                ++i;
            } else {
                token = this.translateText(token);
                this.spans.add(new Span(token, this.font, this.context.getFontRenderContext(), left, baseline));
                ++i;
            }
            left += this.spans.lastElement().getWidth();
        }
        this.width = left;
        this.height = metrics.getHeight();
    }

    private String translateText(String text) {
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        return text;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void paint(Graphics2D g, int x, int y) {
        for (Span span : this.spans) {
            span.paint(g, x, y);
        }
    }

    private class Span {
        private final String text;
        private final GlyphVector vector;
        private final int left;
        private final int baseline;

        public Span(String text, Font font, FontRenderContext context, int left, int baseline) {
            this.text = text;
            this.vector = font.createGlyphVector(context, text);
            this.left = left;
            this.baseline = baseline;
        }

        public int getWidth() {
            return (int)this.vector.getLogicalBounds().getWidth();
        }

        public void paint(Graphics2D g, int x, int y) {
            g.drawGlyphVector(this.vector, x + this.left, y + this.baseline);
        }
    }
}

