/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.ui.arrows.CausalArrowView;
import edu.cmu.hcii.whyline.ui.arrows.FileCausalArrow;
import edu.cmu.hcii.whyline.ui.source.FilesView;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;

public class FileDataArrow
extends FileCausalArrow {
    public FileDataArrow(FilesView.ArrowBox arrows, Explanation definition, Explanation from, Explanation to, int dependencyNumber) {
        super(arrows, definition, from, to, CausalArrowView.Relationship.DATA, dependencyNumber);
        Instruction consumer = to.getProducerFor(definition);
        this.toRange = consumer == null || this.whylineUI.getTrace().getKind((int)to.getEventID()).isArtificial ? this.files.getRangeFor(to.getEventID()) : consumer.getFile().getTokenRangeFor(consumer);
        this.fromRange = this.files.getRangeFor(from.getEventID());
        if (this.fromRange == null || this.fromRange.getFile() == null || this.toRange != null && this.fromRange.first.getLine() == this.toRange.first.getLine()) {
            this.fromRange = null;
        }
    }

    protected void paintSelectedArrow(Graphics2D g, int labelLeft, int labelRight, int labelTop, int labelBottom) {
        Area area;
        g = (Graphics2D)g.create();
        if (this.to != null && this.toRange != null && this.toRange.first != null && (area = this.files.getAreaForTokenRange(this.toRange)) != null) {
            Rectangle tokens = area.getBounds();
            g.setColor(this.relationship.getColor(true));
            this.files.outline(g, this.toRange);
            int tokenLeft = (int)tokens.getMinX();
            int tokenRight = (int)tokens.getMaxX();
            int tokenTop = (int)tokens.getMinY();
            int tokenBottom = (int)tokens.getMaxY();
            int labelX = tokenRight < (labelLeft + labelRight) / 2 ? labelLeft : labelRight;
            int labelY = labelBottom - this.descent;
            if (this.fromRange != null) {
                this.files.outline(g, this.fromRange);
                Area fromArea = this.files.getAreaForTokenRange(this.fromRange);
                if (fromArea != null) {
                    Rectangle fromTokens = fromArea.getBounds();
                    int fromTokenLeft = (int)fromTokens.getMinX();
                    int fromTokenRight = (int)fromTokens.getMaxX();
                    int fromTokenTop = (int)fromTokens.getMinY();
                    int fromTokenBottom = (int)fromTokens.getMaxY();
                    Line2D line = Util.getLineBetweenRectangleEdges(fromTokenLeft, fromTokenRight, fromTokenTop, fromTokenBottom, tokenLeft, tokenRight, tokenTop, tokenBottom);
                    Util.drawQuadraticCurveArrow(g, (int)line.getX1(), (int)line.getY1(), (int)line.getX2(), (int)line.getY2(), 0, 0, true, this.relationship.getStroke(true));
                }
            } else {
                Line2D line = Util.getLineBetweenRectangleEdges(labelX, labelX + 1, labelY, labelY + 1, tokenLeft, tokenRight, tokenTop, tokenBottom);
                int xOff = 0;
                int yOff = 0;
                Util.drawQuadraticCurveArrow(g, (int)line.getX1(), (int)line.getY1(), (int)line.getX2(), (int)line.getY2(), xOff, yOff, true, this.relationship.getStroke(true));
            }
            g.drawLine(labelLeft, labelY, labelRight, labelY);
        }
    }
}

