/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.arrows.CausalArrowView;
import edu.cmu.hcii.whyline.ui.qa.Visualization;
import edu.cmu.hcii.whyline.ui.source.FilesView;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileCausalArrow
extends CausalArrowView {
    private final FilesView.ArrowBox arrows;
    protected final FilesView files;
    protected int left;
    protected int baseline;
    private final GlyphVector glyphs;
    protected final Rectangle2D glyphBounds;
    protected final int descent;
    protected TokenRange toRange;
    protected TokenRange fromRange;

    public FileCausalArrow(FilesView.ArrowBox arrows, Explanation value, Explanation from, Explanation to, CausalArrowView.Relationship relationship, int number) {
        super(arrows.getFilesView().getWhylineUI(), value, from, to, relationship, number);
        this.arrows = arrows;
        this.files = arrows.getFilesView();
        Graphics2D g = (Graphics2D)this.whylineUI.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.glyphs = UI.getSmallFont().createGlyphVector(g.getFontRenderContext(), this.label);
        this.glyphBounds = this.glyphs.getLogicalBounds();
        this.descent = g.getFontMetrics(UI.getSmallFont()).getDescent();
    }

    @Override
    public final List<TokenRange> getViableTargetTokenRanges() {
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>(2);
        if (this.toRange != null && this.toRange.first != null) {
            ranges.add(this.toRange);
        }
        if (this.fromRange != null && this.fromRange.first != null) {
            ranges.add(this.fromRange);
        }
        return ranges;
    }

    @Override
    public boolean containsLocalPoint(int x, int y) {
        return (double)x >= this.getLocalLeft() && (double)x < this.getLocalRight() && (double)y >= this.getLocalTop() && (double)y <= this.getLocalBottom();
    }

    @Override
    public final void layout() {
        Visualization viz;
        Visualization visualization = viz = this.whylineUI.getVisualizationUIVisible() == null ? null : this.whylineUI.getVisualizationUIVisible().getVisualization();
        if (viz == null) {
            return;
        }
        int lineHeight = (int)(this.glyphBounds.getHeight() * 1.25);
        this.baseline = (this.dependencyNumber + 2) * lineHeight;
        this.left = this.arrows.getPadding();
        this.setLocalLeft(this.left, false);
        this.setLocalTop((double)(this.baseline + this.descent) - this.glyphBounds.getHeight(), false);
        this.setLocalWidth(this.glyphBounds.getWidth(), false);
        this.setLocalHeight(lineHeight, false);
    }

    @Override
    public final void paintAboveChildren(Graphics2D g) {
        boolean selected = this.whylineUI.getArrowOver() == this.dependencyNumber;
        g.setColor(UI.getFileColor());
        g.drawGlyphVector(this.glyphs, this.left, this.baseline);
        if (selected) {
            g = (Graphics2D)g.create();
            g.translate(-this.getGlobalLeft() + this.getLocalLeft(), -this.getGlobalTop() + this.getLocalTop());
            int padding = 1;
            int labelLeft = (int)this.getGlobalLeft() - padding;
            int labelRight = labelLeft + (int)this.glyphBounds.getWidth() + padding * 2;
            int labelTop = (int)this.getGlobalTop() - padding;
            int labelBottom = labelTop + (int)this.getGlobalHeight() + padding * 2;
            this.paintSelectedArrow(g, labelLeft, labelRight, labelTop, labelBottom);
        }
    }

    protected abstract void paintSelectedArrow(Graphics2D var1, int var2, int var3, int var4, int var5);
}

