/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui.arrows;

import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.views.View;
import edu.cmu.hcii.whyline.ui.views.ViewContainer;
import java.awt.Graphics2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrowView
extends View {
    protected final WhylineUI whylineUI;
    protected final int dependencyNumber;

    public ArrowView(WhylineUI whylineUI, int number) {
        this.whylineUI = whylineUI;
        this.dependencyNumber = number;
    }

    @Override
    public final boolean handleMouseMove(int x, int y) {
        if (this.getContainer().mouseIsFocused()) {
            return true;
        }
        boolean contains = this.containsLocalPoint(x, y);
        this.whylineUI.setArrowOver(contains ? this.dependencyNumber : -1);
        return contains;
    }

    @Override
    public void handleMouseExit() {
        ViewContainer c = this.getContainer();
        if (c != null && c.mouseIsFocused()) {
            return;
        }
        this.whylineUI.setArrowOver(-1);
    }

    @Override
    public final boolean handleMouseDown(int x, int y, int button) {
        if (!this.containsLocalPoint(x, y)) {
            return false;
        }
        this.clicked();
        return true;
    }

    public abstract List<TokenRange> getViableTargetTokenRanges();

    protected abstract void clicked();

    @Override
    public abstract void paintAboveChildren(Graphics2D var1);

    public abstract boolean containsLocalPoint(int var1, int var2);

    public abstract void layout();
}

