/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.WhyDidEventOccur;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.DynamicNode;
import edu.cmu.hcii.whyline.trace.nodes.FieldState;
import edu.cmu.hcii.whyline.trace.nodes.Node;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.HeadlinedTreePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectsUI
extends HeadlinedTreePanel<ObjectState> {
    private final Action explainAction = new AbstractAction("explain"){

        public void actionPerformed(ActionEvent e) {
            DynamicNode<?> node = ObjectsUI.this.getSelectedDynamicNode();
            if (node != null) {
                int eventID = node.getAssociatedEventID();
                WhyDidEventOccur q = new WhyDidEventOccur((Asker)ObjectsUI.this.whylineUI, eventID, ObjectsUI.this.getTrace().getDescription(eventID));
                ObjectsUI.this.whylineUI.answer(q);
            }
        }
    };
    private final Action removeAction = new AbstractAction("\u2212"){

        public void actionPerformed(ActionEvent e) {
            ObjectsUI.this.whylineUI.getObjectsUI().removeObject(ObjectsUI.this.getSelectedObjectID());
            this.setEnabled(false);
        }
    };
    private final Action previousAssignment = new AbstractAction("previous ="){

        public void actionPerformed(ActionEvent e) {
            Explanation explanation = ObjectsUI.this.getExplanationOfPreviousOrNextFieldAssignment(false);
            if (explanation == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                ObjectsUI.this.whylineUI.selectExplanation(explanation, true, "objects");
            }
        }
    };
    private final Action nextAssignment = new AbstractAction("next ="){

        public void actionPerformed(ActionEvent e) {
            Explanation explanation = ObjectsUI.this.getExplanationOfPreviousOrNextFieldAssignment(true);
            if (explanation == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                ObjectsUI.this.whylineUI.selectExplanation(explanation, true, "objects");
            }
        }
    };

    public ObjectsUI(WhylineUI whylineUI) {
        super("objects", whylineUI);
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), 0));
        this.setPreferredSize(new Dimension(UI.getDefaultInfoPaneWidth(whylineUI), UI.getDefaultInfoPaneHeight(whylineUI)));
        this.removeAction.setEnabled(false);
        this.addTool(new WhylineButton(this.removeAction, "remove the selected object from the watch list"));
        if (whylineUI.isWhyline()) {
            this.addTool(new WhylineButton(this.explainAction, "explain why the selected field has its value"));
            this.addTool(new WhylineButton(this.previousAssignment, "find the previous assignment to this field"));
            this.addTool(new WhylineButton(this.nextAssignment, "find the next assignment to this field"));
        }
    }

    private Explanation getExplanationOfPreviousOrNextFieldAssignment(boolean next) {
        int assignmentID;
        if (!(this.getSelectedDynamicNode() instanceof FieldState)) {
            return null;
        }
        FieldState field = (FieldState)this.getSelectedDynamicNode();
        int eventID = field.getCurrentEventID();
        int n = assignmentID = next ? this.getTrace().findFieldAssignmentAfter(field.getField(), field.getObjectID(), eventID + 1) : this.getTrace().findFieldAssignmentBefore(field.getField(), field.getObjectID(), eventID - 1);
        if (assignmentID == eventID || assignmentID < 0) {
            return null;
        }
        return this.whylineUI.getVisualizationUIVisible().getAnswer().getExplanationFor(assignmentID);
    }

    public boolean isWatching(long objectID) {
        return this.getRoot().getChildren().contains(this.getTrace().getObjectNode(objectID));
    }

    @Override
    protected void handleSelection() {
        Node<?> selection = this.getSelectedNode();
        long objectID = this.getSelectedObjectID();
        this.removeAction.setEnabled(objectID > 0L);
        if (this.whylineUI.isWhyline()) {
            DynamicNode<?> node = this.getSelectedDynamicNode();
            this.explainAction.setEnabled(node != null && node.getAssociatedEventID() > 0);
            if (objectID > 0L) {
                this.whylineUI.getGraphicsUI().setHighlight(this.whylineUI.getTrace().getObjectNode(objectID));
            }
            this.previousAssignment.setEnabled(node instanceof FieldState);
            this.nextAssignment.setEnabled(node instanceof FieldState);
        }
    }

    public long getSelectedObjectID() {
        TreePath path = this.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return 0L;
        }
        Object selection = path.getPathComponent(1);
        return selection instanceof ReferenceState ? ((ReferenceState)selection).getObjectIDForChildren() : 0L;
    }

    public void showEventID(int eventID) {
        if (!this.whylineUI.isDynamicInfoShowing()) {
            return;
        }
        for (ObjectState obj : this.getRoot().getChildren()) {
            obj.propagateCurrentEventID(eventID);
        }
        DynamicNode<?> state = this.getSelectedDynamicNode();
        if (state != null) {
            state.update();
        }
        this.updateTree();
    }

    public void addObject(long objectID) {
        ObjectState obj = this.getTrace().getObjectNode(objectID);
        this.getRoot().addChild(obj);
        this.updateTree();
        this.whylineUI.getPersistentState().addRelevantObject(objectID);
    }

    public void removeObject(long objectID) {
        this.getRoot().removeChild(this.getTrace().getObjectNode(objectID));
        this.updateTree();
        this.whylineUI.getPersistentState().removeRelevantObject(objectID);
    }

    public void removeAllObjects() {
        this.getRoot().resetChildren();
        this.updateTree();
    }

    protected boolean isLeaf(Node<?> node) {
        return node instanceof FieldState;
    }

    public Trace getTrace() {
        return this.whylineUI.getTrace();
    }

    @Override
    protected void handleExpansion() {
        if (this.getSelectedDynamicNode() instanceof ReferenceState) {
            ReferenceState ref = (ReferenceState)this.getSelectedDynamicNode();
            for (ReferenceState node : ref.getChildren()) {
                node.propagateCurrentEventID(ref.getCurrentEventID());
            }
        }
    }
}

