/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.LineTableUI;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineButton;
import edu.cmu.hcii.whyline.ui.components.WhylineControlBorder;
import edu.cmu.hcii.whyline.ui.components.WhylineLabel;
import edu.cmu.hcii.whyline.ui.components.WhylinePanel;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.components.WhylineTabbedPane;
import edu.cmu.hcii.whyline.util.CloseIcon;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class LineTablesUI
extends WhylinePanel {
    private WhylineUI whylineUI;
    private WhylineTabbedPane tabs;
    private final RelevantLines relevantLines;
    private BreakpointLines breakpointLines;
    private History history;
    private Icon closeIcon = new CloseIcon(){

        public boolean isSelected(Component c) {
            return LineTablesUI.this.tabs.getSelectedComponent() == c;
        }
    };

    public LineTablesUI(WhylineUI ui) {
        this.whylineUI = ui;
        this.tabs = new WhylineTabbedPane(){

            public void selectedTabIconPressed(int index) {
                LineTablesUI.this.removeResults(index);
            }
        };
        this.tabs.setBorder(null);
        this.relevantLines = new RelevantLines();
        this.breakpointLines = new BreakpointLines();
        this.history = new History();
        this.setLayout(new BorderLayout(0, UI.getPanelPadding()));
        this.add((Component)this.tabs, "Center");
        this.tabs.insertTab("<html><center>bookmarks", null, this.relevantLines, null, 0);
        this.tabs.insertTab("<html><center>history", null, this.history, null, 1);
        if (this.whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT) {
            this.tabs.insertTab("<html><center>breakpoints", null, this.breakpointLines, null, 2);
        }
        this.setMinimumSize(new Dimension(UI.getDefaultInfoPaneWidth(this.whylineUI), 0));
    }

    private void removeResults(int index) {
        if (this.tabs.getSelectedComponent() instanceof SearchResultsLines) {
            this.tabs.remove(index);
            this.whylineUI.getFilesView().repaint();
        }
    }

    public SearchResultsInterface getSelectedResults() {
        Component selection = this.tabs.getSelectedComponent();
        if (selection instanceof SearchResultsLines) {
            return ((SearchResultsLines)selection).results;
        }
        return null;
    }

    public boolean selectedTabContains(Line line) {
        Component selection = this.tabs.getSelectedComponent();
        if (!(selection instanceof SearchResultsLines)) {
            return false;
        }
        return ((SearchResultsLines)selection).lines.contains(line);
    }

    public Line getSelectedLine() {
        Component selection = this.tabs.getSelectedComponent();
        if (!(selection instanceof SearchResultsLines)) {
            return null;
        }
        return ((SearchResultsLines)selection).lines.getSelection();
    }

    public void addResults(SearchResultsInterface searchResults) {
        this.whylineUI.showStaticInfo(true);
        SearchResultsLines tab = new SearchResultsLines(searchResults);
        int newIndex = this.tabs.getTabCount();
        this.tabs.insertTab(Util.elide(searchResults.getResultsDescription(), 10), this.closeIcon, tab, null, newIndex);
        this.tabs.setSelectedIndex(newIndex);
    }

    public void updateRelevantLines(Line line) {
        this.relevantLines.lines.updateLines(this.whylineUI.getPersistentState().getRelevantLines());
        this.tabs.setSelectedIndex(0);
        this.relevantLines.lines.select(line);
    }

    public void updateHistory(Line line) {
        this.history.lines.updateLines(this.whylineUI.getNavigationHistory());
        this.history.lines.select(0);
    }

    public void updateBreakpointLines(Line line) {
        List<Line> linesSet = this.whylineUI.getBreakpointDebugger().getLinesWithBreakpointsOrPrints();
        this.breakpointLines.lines.updateLines(linesSet);
        this.tabs.setSelectedIndex(2);
        this.breakpointLines.lines.select(line);
        this.whylineUI.getFilesView().repaint();
    }

    private class BreakpointLines
    extends LinePanel {
        private BreakpointLines() {
            super("search", true);
            this.add((Component)this.lines, "Center");
            this.add((Component)new WhylineButton(((LineTablesUI)LineTablesUI.this).whylineUI.getActions().clearBreakpoints, "clear all breakpoints"), "South");
        }
    }

    private class History
    extends LinePanel {
        private History() {
            super("search", false);
        }
    }

    private class LinePanel
    extends WhylinePanel {
        protected LineTableUI lines;

        public LinePanel(String uiString, boolean addSelectionsToHistory) {
            this.lines = new LineTableUI(LineTablesUI.this.whylineUI, new ArrayList<Line>(0), uiString, addSelectionsToHistory);
            this.setLayout(new BorderLayout());
            this.setBackground(UI.getControlBackColor());
            this.setOpaque(true);
            this.setBorder(new WhylineControlBorder());
            this.add((Component)new WhylineScrollPane(this.lines), "Center");
        }
    }

    class LineRenderer
    extends JLabel
    implements ListCellRenderer {
        private LineRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Line line = (Line)value;
            String label = "<html><b>" + Util.fillOrTruncateString(line.getFile().getShortFileName(), 15) + ": " + Util.fillOrTruncateString(Integer.toString(line.getLineNumber().getNumber()), 10) + "</b>" + line.getLineText();
            label = label.replace(" ", "&nbsp;");
            this.setText(label);
            if (isSelected) {
                this.setBackground(UI.getHighlightColor());
                this.setForeground(Color.white);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class RelevantLines
    extends LinePanel {
        private RelevantLines() {
            super("search", true);
        }
    }

    private class SearchResultsLines
    extends WhylinePanel {
        private final LineTableUI lines;
        private final WhylineLabel status;
        private List<Line> resultLines;
        private SearchResultsInterface results;
        private Timer timer;

        public SearchResultsLines(SearchResultsInterface searchResults) {
            super(new BorderLayout());
            this.resultLines = new ArrayList<Line>();
            this.results = searchResults;
            float fontSize = 10.0f;
            this.status = new WhylineLabel("", fontSize);
            this.status.setHorizontalAlignment(0);
            this.lines = new LineTableUI(LineTablesUI.this.whylineUI, this.resultLines, "search", true);
            this.lines.setFocusable(true);
            WhylineScrollPane scroller = new WhylineScrollPane(this.lines);
            scroller.setBorder(new WhylineControlBorder());
            WhylineLabel title = new WhylineLabel("<html><i>" + searchResults.getResultsDescription() + "</i>...", UI.getMediumFont().deriveFont(1));
            title.setHorizontalAlignment(0);
            title.setBorder(new EmptyBorder(UI.getPanelPadding(), 0, 0, 0));
            this.add((Component)title, "North");
            this.add((Component)scroller, "Center");
            this.add((Component)this.status, "South");
            this.setPreferredSize(new Dimension(UI.getDefaultInfoPaneWidth(LineTablesUI.this.whylineUI), UI.getDefaultInfoPaneHeight(LineTablesUI.this.whylineUI) * 2 / 3));
            this.timer = new Timer("Search results feedback", true);
            this.timer.schedule(new TimerTask(){

                public void run() {
                    SearchResultsLines.this.updateCurrentResults();
                    if (SearchResultsLines.this.results.isDone()) {
                        SearchResultsLines.this.timer.cancel();
                        SearchResultsLines.this.timer = null;
                    }
                }
            }, 0L, 500L);
        }

        public void updateCurrentResults() {
            this.status.setText(this.results.getCurrentStatus());
            SortedSet<Token> tokens = this.results.getResults();
            TreeSet<Line> resultSet = new TreeSet<Line>();
            for (Token t : tokens) {
                resultSet.add(t.getLine());
            }
            this.resultLines.clear();
            this.resultLines.addAll(resultSet);
            this.lines.updateLines(this.resultLines);
        }
    }
}

