/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.ui;

import edu.cmu.hcii.whyline.analysis.Usage;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineList;
import edu.cmu.hcii.whyline.ui.components.WhylineMenuItem;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.components.WhylineScrollPane;
import edu.cmu.hcii.whyline.ui.components.WhylineToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DebugMenu
extends JLabel {
    private final WhylineUI whylineUI;

    public DebugMenu(WhylineUI whylineUI) {
        super(UI.WHYLINE_ICON);
        this.whylineUI = whylineUI;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DebugMenu.this.showMenu(e.getX(), e.getY());
            }
        });
    }

    private void showMenu(int x, int y) {
        WhylinePopup popup = new WhylinePopup("");
        boolean done = this.whylineUI.getTrace().isDoneLoading();
        WhylineMenuItem saveas = new WhylineMenuItem("Save as...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.whylineUI.save(false);
            }
        });
        saveas.setEnabled(done);
        WhylineMenuItem breakdown = new WhylineMenuItem("Show trace memory breakdown...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.whylineUI.showTraceBreakdown();
            }
        });
        breakdown.setEnabled(done);
        WhylineMenuItem usage = new WhylineMenuItem("Generate usage statistics from usage logs...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DebugMenu.this.generateUsageStatistics();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        WhylineMenuItem browser = new WhylineMenuItem("Show event list...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Browser();
            }
        });
        WhylineMenuItem memory = new WhylineMenuItem("Show memory usage...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.whylineUI.showMemoryUsage();
            }
        });
        WhylineMenuItem showfile = new WhylineMenuItem("Show a file...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.showFile();
            }
        });
        popup.add(saveas);
        popup.add(breakdown);
        popup.add(usage);
        popup.add(browser);
        popup.add(memory);
        popup.add(showfile);
        popup.show(this, x, y);
    }

    private void showFile() {
        String name = JOptionPane.showInputDialog(this.whylineUI, (Object)"What's the qualified file class name?");
        if (name != null) {
            this.whylineUI.selectFile(this.whylineUI.getTrace().getSourceByQualifiedName(name), true, "debug");
        }
    }

    private void generateUsageStatistics() throws IOException {
        String methodname = JOptionPane.showInputDialog(this.whylineUI, (Object)"Which method is the bug in (e.g., \"java/lang/Character.isDefined(C)Z\")?");
        if (methodname == null) {
            return;
        }
        String[] names = methodname.split("\\.");
        if (names.length != 2) {
            JOptionPane.showMessageDialog(this.whylineUI, "Couldn't split into class and method name");
            return;
        }
        Classfile buggyClass = this.whylineUI.getTrace().getClassfileByName(QualifiedClassName.get(names[0]));
        if (buggyClass == null) {
            JOptionPane.showMessageDialog(this.whylineUI, "Couldn't find class " + names[0]);
            return;
        }
        MethodInfo buggyMethod = buggyClass.getDeclaredMethodByNameAndDescriptor(names[1]);
        if (buggyMethod == null) {
            JOptionPane.showMessageDialog(this.whylineUI, "Couldn't find method " + names[1] + " in " + names[0]);
            return;
        }
        JFileChooser chooser = new JFileChooser(this.whylineUI.getTrace().getPath());
        chooser.setDialogTitle("Select a folder that contains the usage logs to analyze");
        chooser.setFileHidingEnabled(true);
        chooser.setFileSelectionMode(1);
        int choice = chooser.showOpenDialog(this.whylineUI);
        if (choice != 0) {
            return;
        }
        File folder = chooser.getSelectedFile();
        Usage usage = new Usage(this.whylineUI.getTrace(), folder, buggyMethod);
        JOptionPane.showMessageDialog(this.whylineUI, "Saved 'results.csv' in " + folder.getName());
    }

    private class Browser
    extends JFrame {
        private final int lineHeight;
        private final WhylineList list;
        private final JSlider slider;

        public Browser() {
            super("Event browser");
            EmptyBorder padding = new EmptyBorder(UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding(), UI.getPanelPadding());
            Font font = UI.getFixedFont();
            this.lineHeight = DebugMenu.this.whylineUI.getGraphics().getFontMetrics(font).getHeight();
            this.list = new WhylineList();
            this.list.setFont(font);
            this.list.setBorder(padding);
            this.slider = new JSlider(1, 0, DebugMenu.this.whylineUI.getTrace().getNumberOfEvents() - 1, 0);
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    Browser.this.refocus();
                }
            });
            WhylineToolbar toolbar = new WhylineToolbar(1);
            toolbar.setBorder(padding);
            toolbar.add(this.slider);
            toolbar.add(new AbstractAction(String.valueOf('\u2192')){

                public void actionPerformed(ActionEvent e) {
                    Browser.this.slider.setValue(Browser.this.slider.getValue() - Browser.this.getWindow());
                }
            });
            toolbar.add(new AbstractAction(String.valueOf('\u2190')){

                public void actionPerformed(ActionEvent e) {
                    Browser.this.slider.setValue(Browser.this.slider.getValue() + Browser.this.getWindow());
                }
            });
            this.getContentPane().addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    Browser.this.refocus();
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new WhylineScrollPane(this.list), "Center");
            this.getContentPane().add((Component)toolbar, "East");
            this.refocus();
            this.setSize(640, 480);
            this.setVisible(true);
        }

        public int getWindow() {
            return this.list.getParent().getHeight() / (this.lineHeight + 3) / 2;
        }

        private void refocus() {
            int window;
            int min = window = this.getWindow();
            int max = DebugMenu.this.whylineUI.getTrace().getNumberOfEvents() - window - 1;
            int eventID = Math.max(min, Math.min(max, max - this.slider.getValue()));
            String[] events = new String[window * 2];
            eventID -= window;
            int i = 0;
            while (i < window * 2) {
                events[i] = DebugMenu.this.whylineUI.getTrace().eventToString(eventID);
                ++eventID;
                ++i;
            }
            this.list.setListData(events);
        }
    }
}

