/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.tracing.AgentOptions;
import edu.cmu.hcii.whyline.tracing.ExecutionConfiguration;
import edu.cmu.hcii.whyline.tracing.ProcessListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class Runner {
    private final String[] args;
    private Process process;
    private final ProcessListener listener;
    private final ExecutionThread thread;

    public Runner(File whylineJARPath, ExecutionConfiguration config, AgentOptions options, ProcessListener listener) {
        this.args = config.getExecutionCommand(whylineJARPath, options, false);
        this.listener = listener;
        this.thread = new ExecutionThread();
    }

    public void execute() {
        this.thread.start();
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private class ExecutionThread
    extends Thread {
        private ExecutionThread() {
        }

        public void run() {
            Runner.this.process = null;
            try {
                Runner.this.process = Runtime.getRuntime().exec(Runner.this.args);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                Runner.this.listener.processDone(e2.toString(), -1);
                return;
            }
            StreamGobbler errorGobbler = new StreamGobbler(Runner.this.process.getErrorStream(), Type.ERR);
            StreamGobbler outputGobbler = new StreamGobbler(Runner.this.process.getInputStream(), Type.OUT);
            int exitValue = 0;
            try {
                errorGobbler.start();
                outputGobbler.start();
                exitValue = Runner.this.process.waitFor();
                if (exitValue == 711) {
                    String errorMessage = "The program failed because the Whyline messed it up. Don't worry it's not your fault.";
                    if (errorGobbler.getError() != null) {
                        errorMessage = String.valueOf(errorMessage) + "\nThe error stream had this line in it: " + errorGobbler.getError();
                    }
                    if (outputGobbler.getError() != null) {
                        errorMessage = String.valueOf(errorMessage) + "\nThe output stream had this line in it: " + outputGobbler.getError();
                    }
                    Runner.this.listener.processDone(errorMessage, exitValue);
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Runner.this.listener.processDone(e.getMessage(), exitValue);
                return;
            }
            Runner.this.listener.processDone(null, exitValue);
        }
    }

    private class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final Type type;
        private String error = null;

        StreamGobbler(InputStream is, Type type) {
            this.setPriority(1);
            this.is = is;
            this.type = type;
        }

        public String getError() {
            return this.error;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.type == Type.OUT) {
                        Runner.this.listener.outputStream(line);
                    } else if (this.type == Type.ERR) {
                        Runner.this.listener.errorStream(line);
                    }
                    if (!line.contains("Exception in thread")) continue;
                    this.error = line;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        OUT,
        ERR;

    }
}

